/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.omron.fins.core.encoder;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;

public class ValueEncoder {
    public static float getFloat(byte[] pack, int index) {
        int bits = 0;
        bits += (pack[1] & 0xFF) << 0;
        bits += (pack[0] & 0xFF) << 8;
        bits += (pack[3] & 0xFF) << 16;
        return Float.intBitsToFloat(bits += (pack[2] & 0xFF) << 24);
    }

    public static long getDWord(byte[] pack, int index) {
        long value = 0L;
        value += (long)((pack[index + 1] & 0xFF) * 1);
        value += (long)((pack[index + 0] & 0xFF) * 256);
        value += (long)((pack[index + 3] & 0xFF) * 65536);
        return value += (long)((pack[index + 2] & 0xFF) * 0x1000000);
    }

    public static void setDword(byte[] pack, int index, long value) {
        pack[index + 1] = (byte)(value & 0xFFL);
        pack[index + 0] = (byte)(value >> 8 & 0xFFL);
        pack[index + 3] = (byte)(value >> 16 & 0xFFL);
        pack[index + 2] = (byte)(value >> 24 & 0xFFL);
    }

    public static int getWord(byte[] pack, int index) {
        int value = 0;
        value += (pack[index + 1] & 0xFF) * 1;
        return value += (pack[index + 0] & 0xFF) * 256;
    }

    public static void setWord(byte[] pack, int index, int value) {
        pack[index + 1] = (byte)(value & 0xFF);
        pack[index + 0] = (byte)(value >> 8 & 0xFF);
    }

    public static Object decodeReadData(byte[] value, int count, String clazz) {
        if (value.length < 2) {
            throw new ProtocolException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6570\u636e\uff01");
        }
        if (String.class.getSimpleName().equals(clazz)) {
            char ch;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < value.length && (ch = (char)value[i]) != '\u0000'; ++i) {
                sb.append((char)value[i]);
            }
            return sb.toString();
        }
        if (Integer.class.getSimpleName().equals(clazz) && value.length == 4) {
            return ValueEncoder.getDWord(value, 0);
        }
        if (Short.class.getSimpleName().equals(clazz) && value.length == 2) {
            return ValueEncoder.getWord(value, 0);
        }
        if (Float.class.getSimpleName().equals(clazz) && value.length == 4) {
            return Float.valueOf(ValueEncoder.getFloat(value, 0));
        }
        return null;
    }

    public static <T> Object decodeReadData(byte[] value, int count, Class<T> clazz) {
        if (value.length < 2) {
            throw new ProtocolException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6570\u636e\uff01");
        }
        if (String.class.equals(clazz)) {
            char ch;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < value.length && (ch = (char)value[i]) != '\u0000'; ++i) {
                sb.append((char)value[i]);
            }
            return sb.toString();
        }
        if (Integer.class.equals(clazz) && value.length == 4) {
            return ValueEncoder.getDWord(value, 0);
        }
        if (Short.class.equals(clazz) && value.length == 2) {
            return ValueEncoder.getWord(value, 0);
        }
        if (Float.class.equals(clazz) && value.length == 4) {
            return Float.valueOf(ValueEncoder.getFloat(value, 0));
        }
        return null;
    }
}

