/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.omron.fins.core.encoder;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.omron.fins.core.encoder.ValueEncoder;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.ReadDataRequest;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.ReadDataRespond;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.Respond;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.WriteDataRequest;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.WriteDataRespond;

public class DataEncoder {
    public static byte[] encodeReadData(ReadDataRequest request) {
        byte[] data = new byte[6];
        data[0] = (byte)request.getArea();
        data[1] = (byte)(request.getWordAddress() >> 8 & 0xFF);
        data[2] = (byte)(request.getWordAddress() & 0xFF);
        data[3] = (byte)(request.getBitAddress() & 0xFF);
        ValueEncoder.setWord(data, 4, request.getCount());
        return data;
    }

    public static <T> ReadDataRespond decodeReadData(byte[] data) {
        if (data.length < 2) {
            throw new ProtocolException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6570\u636e\uff01");
        }
        ReadDataRespond respond = new ReadDataRespond();
        respond.setMain(data[0]);
        respond.setSub(data[1]);
        byte[] value = new byte[data.length - 2];
        System.arraycopy(data, 2, value, 0, value.length);
        respond.setData(value);
        return respond;
    }

    public static byte[] encodeWriteData(WriteDataRequest request) {
        byte[] data = new byte[4 + request.getData().length];
        data[0] = (byte)request.getArea();
        data[1] = (byte)(request.getWordAddress() & 0xFF);
        data[2] = (byte)(request.getWordAddress() >> 8 & 0xFF);
        data[3] = (byte)request.getBitAddress();
        System.arraycopy(request.getData(), 4, data, 0, request.getData().length);
        return data;
    }

    public static WriteDataRespond decodeWriteData(byte[] data) {
        if (data.length != 2) {
            throw new ProtocolException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6570\u636e\uff01");
        }
        WriteDataRespond respond = new WriteDataRespond();
        respond.setMain(data[0]);
        respond.setSub(data[1]);
        return respond;
    }

    public static Respond decodeEndCode(byte[] data) {
        if (data.length < 2) {
            throw new ProtocolException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u6570\u636e\uff01");
        }
        Respond endCode = new Respond();
        endCode.setMain(data[0]);
        endCode.setSub(data[1]);
        return endCode;
    }
}

