/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.omron.fins.core.encoder;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeLinkerAction;
import cn.foxtech.device.protocol.v1.omron.fins.core.encoder.DataEncoder;
import cn.foxtech.device.protocol.v1.omron.fins.core.encoder.PduEncoder;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.data.Respond;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.ConnectRequest;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.ConnectRespond;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.TransferRespond;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.Map;

@FoxEdgeDeviceType(value="omron-fins", manufacturer="\u6b27\u59c6\u9f99")
public class LinkerEncoder {
    @FoxEdgeLinkerAction(value="createLinkerRequest")
    public static Object encodeCreateLinkerRequest(Map<String, Object> param) throws Exception {
        Integer clientNode = (Integer)param.get("clientNode");
        ConnectRequest session = new ConnectRequest();
        session.setClientNode(clientNode);
        byte[] pack = PduEncoder.encodePduPack(session);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeLinkerAction(value="createLinkerRespond")
    public static boolean decodeCreateLinkerRespond(Map<String, Object> param, Object respond) throws Exception {
        byte[] pack = HexUtils.hexStringToByteArray((String)((String)respond));
        ConnectRespond connectRespond = PduEncoder.decodePdu(pack, ConnectRespond.class);
        return true;
    }

    @FoxEdgeLinkerAction(value="activeLinkerRequest")
    public static Object encodeActiveLinkerRequest(Map<String, Object> param) throws Exception {
        return "";
    }

    @FoxEdgeLinkerAction(value="activeLinkerRespond")
    public static boolean decodeActiveLinkerRespond(Map<String, Object> param, Object respond) throws Exception {
        byte[] pack = HexUtils.hexStringToByteArray((String)((String)respond));
        TransferRespond transferRespond = PduEncoder.decodePdu(pack, TransferRespond.class);
        Respond endCode = DataEncoder.decodeEndCode(transferRespond.getData());
        StringBuilder sb = new StringBuilder();
        Respond.checkEndCode(endCode.getMain(), endCode.getSub(), sb);
        return endCode.getMain() == 0 && endCode.getSub() == 0;
    }

    @FoxEdgeLinkerAction(value="interceptLinkerRespond")
    public static boolean decodeInterceptLinkerRespond(Map<String, Object> param, Object respond) throws Exception {
        byte[] pack = HexUtils.hexStringToByteArray((String)((String)respond));
        TransferRespond transferRespond = PduEncoder.decodePdu(pack, TransferRespond.class);
        Respond endCode = DataEncoder.decodeEndCode(transferRespond.getData());
        StringBuilder sb = new StringBuilder();
        Respond.checkEndCode(endCode.getMain(), endCode.getSub(), sb);
        return true;
    }
}

