/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus.template;

import cn.foxtech.device.protocol.v1.core.context.ApplicationContext;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.ITemplate;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteRegistersRequest;
import cn.foxtech.device.protocol.v1.utils.BitsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JReadRegistersTemplate
implements ITemplate {
    public static final String READ_HOLDING_REGISTER = "Read Holding Register";
    public static final String READ_INPUT_REGISTER = "Read Input Register";
    public static final String WRITE_SINGLE_REGISTER = "Write Single Register";
    private JDecoderParam decoderParam = new JDecoderParam();

    public String getSysTemplateName() {
        return "register default";
    }

    public void loadJsnModel(String modelName) {
        Map deviceTemplateEntity = ApplicationContext.getDeviceModels((String)modelName);
        Long updateTime = deviceTemplateEntity.getOrDefault("updateTime", 0L);
        if (this.decoderParam.updateTime.equals(updateTime)) {
            return;
        }
        Map modelParam = deviceTemplateEntity.getOrDefault("modelParam", new HashMap());
        List rows = modelParam.getOrDefault("list", new ArrayList());
        HashMap<String, JDecoderValueParam> map = new HashMap<String, JDecoderValueParam>();
        for (Map row : rows) {
            if (row.size() < 7) continue;
            JDecoderValueParam jDecoderValueParam = new JDecoderValueParam();
            jDecoderValueParam.value_name = (String)row.get("value_name");
            jDecoderValueParam.value_index = this.getInteger(row.get("value_index"));
            jDecoderValueParam.bit_index = this.getInteger(row.get("bit_index"));
            jDecoderValueParam.bit_length = this.getInteger(row.get("bit_length"));
            jDecoderValueParam.value_type = (String)row.get("value_type");
            jDecoderValueParam.magnification = this.getDouble(row.get("magnification"));
            jDecoderValueParam.determine = (String)row.get("determine");
            map.put(jDecoderValueParam.getValue_name(), jDecoderValueParam);
        }
        this.decoderParam.valueMap = map;
        this.decoderParam.table = modelName;
        this.decoderParam.updateTime = updateTime;
        this.decoderParam.sourceType = "jsn";
    }

    private Integer getInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    private Double getDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        return null;
    }

    public Map<String, Object> decode(int address, int count, int[] statusList) throws ProtocolException {
        return this.decodeValue(address, count, statusList);
    }

    public ModBusWriteRegistersRequest encode(String objectName, Object objectValue) {
        ModBusWriteRegistersRequest request = new ModBusWriteRegistersRequest();
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.valueMap.get(objectName);
        if (jDecoderValueParam == null) {
            throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f");
        }
        if (jDecoderValueParam.value_type.equals("int")) {
            request.setMemAddr(jDecoderValueParam.value_index.intValue());
            request.setValue((int)((double)Integer.valueOf(objectValue.toString()).intValue() / jDecoderValueParam.magnification));
            return request;
        }
        if (jDecoderValueParam.value_type.equals("long")) {
            request.setMemAddr(jDecoderValueParam.value_index.intValue());
            request.setValue((int)((double)Integer.valueOf(objectValue.toString()).intValue() / jDecoderValueParam.magnification));
            return request;
        }
        if (jDecoderValueParam.value_type.equals("float")) {
            request.setMemAddr(jDecoderValueParam.value_index.intValue());
            request.setValue((int)((double)Float.valueOf(objectValue.toString()).floatValue() / jDecoderValueParam.magnification));
            return request;
        }
        throw new ProtocolException("\u4e0d\u652f\u6301\u5bf9\u8be5\u6570\u636e\u8fdb\u884c\u7f16\u7801\uff1a" + objectName);
    }

    private Map<String, Object> decodeValue(int address, int count, int[] statusList) {
        int offsetStart = address;
        int offsetEnd = address + count - 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : this.decoderParam.valueMap.entrySet()) {
            int index;
            String name = (String)entry.getKey();
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)entry.getValue();
            if (jDecoderValueParam.value_index < offsetStart || jDecoderValueParam.value_index > offsetEnd + 1 || (index = jDecoderValueParam.value_index - offsetStart) >= statusList.length) continue;
            int status = statusList[index];
            if (jDecoderValueParam.value_type.equals("int")) {
                result.put(name, (int)((double)status * jDecoderValueParam.magnification));
            }
            if (jDecoderValueParam.value_type.equals("long")) {
                if (statusList.length <= index + 1) continue;
                status = statusList[index] * 65536 + statusList[index + 1];
                result.put(name, (long)((double)status * jDecoderValueParam.magnification));
            }
            if (jDecoderValueParam.value_type.equals("fix-float")) {
                result.put(name, (double)status * jDecoderValueParam.magnification);
            }
            if (jDecoderValueParam.value_type.equals("float") && jDecoderValueParam.bit_length.equals(32)) {
                byte bit0 = (byte)(statusList[index + 1] >> 0 & 0xFF);
                byte bit1 = (byte)(statusList[index + 1] >> 8 & 0xFF);
                byte bit2 = (byte)(statusList[index + 0] >> 0 & 0xFF);
                byte bit3 = (byte)(statusList[index + 0] >> 8 & 0xFF);
                float fValue = BitsUtils.bitsToFloat((byte)bit0, (byte)bit1, (byte)bit2, (byte)bit3);
                result.put(name, (double)fValue * jDecoderValueParam.magnification);
            }
            if (!jDecoderValueParam.value_type.equals("bool")) continue;
            int value = 0;
            for (int i = 0; i < jDecoderValueParam.bit_length; ++i) {
                value += status & this.binary(jDecoderValueParam.bit_index + i);
            }
            if (jDecoderValueParam.determine.equals(">0")) {
                result.put(name, value > 0);
                continue;
            }
            result.put(name, value == 0);
        }
        return result;
    }

    private int binary(int pos) {
        int value = 1;
        while (pos-- >= 0) {
            value *= 2;
        }
        return value / 2;
    }

    public JDecoderParam getDecoderParam() {
        return this.decoderParam;
    }

    public void setDecoderParam(JDecoderParam decoderParam) {
        this.decoderParam = decoderParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JReadRegistersTemplate)) {
            return false;
        }
        JReadRegistersTemplate other = (JReadRegistersTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JDecoderParam this$decoderParam = this.getDecoderParam();
        JDecoderParam other$decoderParam = other.getDecoderParam();
        return !(this$decoderParam == null ? other$decoderParam != null : !((Object)this$decoderParam).equals(other$decoderParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JReadRegistersTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JDecoderParam $decoderParam = this.getDecoderParam();
        result = result * 59 + ($decoderParam == null ? 43 : ((Object)$decoderParam).hashCode());
        return result;
    }

    public String toString() {
        return "JReadRegistersTemplate(decoderParam=" + this.getDecoderParam() + ")";
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String value_name;
        private Integer value_index;
        private Integer bit_index;
        private Integer bit_length;
        private String value_type;
        private Double magnification;
        private String determine;

        public String getValue_name() {
            return this.value_name;
        }

        public Integer getValue_index() {
            return this.value_index;
        }

        public Integer getBit_index() {
            return this.bit_index;
        }

        public Integer getBit_length() {
            return this.bit_length;
        }

        public String getValue_type() {
            return this.value_type;
        }

        public Double getMagnification() {
            return this.magnification;
        }

        public String getDetermine() {
            return this.determine;
        }

        public void setValue_name(String value_name) {
            this.value_name = value_name;
        }

        public void setValue_index(Integer value_index) {
            this.value_index = value_index;
        }

        public void setBit_index(Integer bit_index) {
            this.bit_index = bit_index;
        }

        public void setBit_length(Integer bit_length) {
            this.bit_length = bit_length;
        }

        public void setValue_type(String value_type) {
            this.value_type = value_type;
        }

        public void setMagnification(Double magnification) {
            this.magnification = magnification;
        }

        public void setDetermine(String determine) {
            this.determine = determine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$value_index = this.getValue_index();
            Integer other$value_index = other.getValue_index();
            if (this$value_index == null ? other$value_index != null : !((Object)this$value_index).equals(other$value_index)) {
                return false;
            }
            Integer this$bit_index = this.getBit_index();
            Integer other$bit_index = other.getBit_index();
            if (this$bit_index == null ? other$bit_index != null : !((Object)this$bit_index).equals(other$bit_index)) {
                return false;
            }
            Integer this$bit_length = this.getBit_length();
            Integer other$bit_length = other.getBit_length();
            if (this$bit_length == null ? other$bit_length != null : !((Object)this$bit_length).equals(other$bit_length)) {
                return false;
            }
            Double this$magnification = this.getMagnification();
            Double other$magnification = other.getMagnification();
            if (this$magnification == null ? other$magnification != null : !((Object)this$magnification).equals(other$magnification)) {
                return false;
            }
            String this$value_name = this.getValue_name();
            String other$value_name = other.getValue_name();
            if (this$value_name == null ? other$value_name != null : !this$value_name.equals(other$value_name)) {
                return false;
            }
            String this$value_type = this.getValue_type();
            String other$value_type = other.getValue_type();
            if (this$value_type == null ? other$value_type != null : !this$value_type.equals(other$value_type)) {
                return false;
            }
            String this$determine = this.getDetermine();
            String other$determine = other.getDetermine();
            return !(this$determine == null ? other$determine != null : !this$determine.equals(other$determine));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $value_index = this.getValue_index();
            result = result * 59 + ($value_index == null ? 43 : ((Object)$value_index).hashCode());
            Integer $bit_index = this.getBit_index();
            result = result * 59 + ($bit_index == null ? 43 : ((Object)$bit_index).hashCode());
            Integer $bit_length = this.getBit_length();
            result = result * 59 + ($bit_length == null ? 43 : ((Object)$bit_length).hashCode());
            Double $magnification = this.getMagnification();
            result = result * 59 + ($magnification == null ? 43 : ((Object)$magnification).hashCode());
            String $value_name = this.getValue_name();
            result = result * 59 + ($value_name == null ? 43 : $value_name.hashCode());
            String $value_type = this.getValue_type();
            result = result * 59 + ($value_type == null ? 43 : $value_type.hashCode());
            String $determine = this.getDetermine();
            result = result * 59 + ($determine == null ? 43 : $determine.hashCode());
            return result;
        }

        public String toString() {
            return "JReadRegistersTemplate.JDecoderValueParam(value_name=" + this.getValue_name() + ", value_index=" + this.getValue_index() + ", bit_index=" + this.getBit_index() + ", bit_length=" + this.getBit_length() + ", value_type=" + this.getValue_type() + ", magnification=" + this.getMagnification() + ", determine=" + this.getDetermine() + ")";
        }
    }

    public static class JDecoderParam
    implements Serializable {
        private Object updateTime = 0;
        private String sourceType = "csv";
        private String table;
        private Map<String, JDecoderValueParam> valueMap = new HashMap<String, JDecoderValueParam>();

        public Object getUpdateTime() {
            return this.updateTime;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getTable() {
            return this.table;
        }

        public Map<String, JDecoderValueParam> getValueMap() {
            return this.valueMap;
        }

        public void setUpdateTime(Object updateTime) {
            this.updateTime = updateTime;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setValueMap(Map<String, JDecoderValueParam> valueMap) {
            this.valueMap = valueMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderParam)) {
                return false;
            }
            JDecoderParam other = (JDecoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$updateTime = this.getUpdateTime();
            Object other$updateTime = other.getUpdateTime();
            if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
                return false;
            }
            String this$sourceType = this.getSourceType();
            String other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Map<String, JDecoderValueParam> this$valueMap = this.getValueMap();
            Map<String, JDecoderValueParam> other$valueMap = other.getValueMap();
            return !(this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $updateTime = this.getUpdateTime();
            result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
            String $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Map<String, JDecoderValueParam> $valueMap = this.getValueMap();
            result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
            return result;
        }

        public String toString() {
            return "JReadRegistersTemplate.JDecoderParam(updateTime=" + this.getUpdateTime() + ", sourceType=" + this.getSourceType() + ", table=" + this.getTable() + ", valueMap=" + this.getValueMap() + ")";
        }
    }
}

