/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus.template;

import cn.foxtech.device.protocol.v1.core.context.ApplicationContext;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.ITemplate;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteStatusRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JReadStatusTemplate
implements ITemplate {
    public static final String READ_COIL_STATUS = "Read Coil Status";
    public static final String READ_DISCRETE_INPUT_STATUS = "Read Discrete Input Status";
    public static final String WRITE_SINGLE_STATUS = "Write Single Status";
    private JDecoderParam decoderParam = new JDecoderParam();

    public String getSysTemplateName() {
        return "status default";
    }

    public void loadJsnModel(String modelName) {
        Map deviceTemplateEntity = ApplicationContext.getDeviceModels((String)modelName);
        Long updateTime = deviceTemplateEntity.getOrDefault("updateTime", 0L);
        if (this.decoderParam.updateTime.equals(updateTime)) {
            return;
        }
        Map modelParam = deviceTemplateEntity.getOrDefault("modelParam", new HashMap());
        List rows = modelParam.getOrDefault("list", new ArrayList());
        HashMap<String, JDecoderValueParam> map = new HashMap<String, JDecoderValueParam>();
        for (Map row : rows) {
            if (row.size() < 2) continue;
            JDecoderValueParam jDecoderValueParam = new JDecoderValueParam();
            jDecoderValueParam.value_name = (String)row.get("value_name");
            jDecoderValueParam.value_index = this.getInteger(row.get("value_index"));
            map.put(jDecoderValueParam.getValue_name(), jDecoderValueParam);
        }
        this.decoderParam.valueMap = map;
        this.decoderParam.table = modelName;
        this.decoderParam.updateTime = updateTime;
        this.decoderParam.sourceType = "jsn";
    }

    private Integer getInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    public Map<String, Object> decode(int address, int coilCount, boolean[] statusList) throws ProtocolException {
        return this.decodeValue(address, coilCount, statusList);
    }

    public ModBusWriteStatusRequest encode(String objectName, Object objectValue) {
        ModBusWriteStatusRequest request = new ModBusWriteStatusRequest();
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.valueMap.get(objectName);
        if (jDecoderValueParam == null) {
            throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f");
        }
        request.setMemAddr(jDecoderValueParam.value_index.intValue());
        request.setStatus(Boolean.valueOf(objectValue.toString()).booleanValue());
        return request;
    }

    private Map<String, Object> decodeValue(int address, int count, boolean[] statusList) {
        int offsetStart = address;
        int offsetEnd = address + count - 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : this.decoderParam.valueMap.entrySet()) {
            int index;
            String name = (String)entry.getKey();
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)entry.getValue();
            if (jDecoderValueParam.value_index < offsetStart || jDecoderValueParam.value_index > offsetEnd + 1 || (index = jDecoderValueParam.value_index - offsetStart) >= statusList.length) continue;
            boolean status = statusList[index];
            result.put(name, status);
        }
        return result;
    }

    private int binary(int pos) {
        int value = 1;
        while (pos-- >= 0) {
            value *= 2;
        }
        return value / 2;
    }

    public JDecoderParam getDecoderParam() {
        return this.decoderParam;
    }

    public void setDecoderParam(JDecoderParam decoderParam) {
        this.decoderParam = decoderParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JReadStatusTemplate)) {
            return false;
        }
        JReadStatusTemplate other = (JReadStatusTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JDecoderParam this$decoderParam = this.getDecoderParam();
        JDecoderParam other$decoderParam = other.getDecoderParam();
        return !(this$decoderParam == null ? other$decoderParam != null : !((Object)this$decoderParam).equals(other$decoderParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JReadStatusTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JDecoderParam $decoderParam = this.getDecoderParam();
        result = result * 59 + ($decoderParam == null ? 43 : ((Object)$decoderParam).hashCode());
        return result;
    }

    public String toString() {
        return "JReadStatusTemplate(decoderParam=" + this.getDecoderParam() + ")";
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String value_name;
        private Integer value_index;

        public String getValue_name() {
            return this.value_name;
        }

        public Integer getValue_index() {
            return this.value_index;
        }

        public void setValue_name(String value_name) {
            this.value_name = value_name;
        }

        public void setValue_index(Integer value_index) {
            this.value_index = value_index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$value_index = this.getValue_index();
            Integer other$value_index = other.getValue_index();
            if (this$value_index == null ? other$value_index != null : !((Object)this$value_index).equals(other$value_index)) {
                return false;
            }
            String this$value_name = this.getValue_name();
            String other$value_name = other.getValue_name();
            return !(this$value_name == null ? other$value_name != null : !this$value_name.equals(other$value_name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $value_index = this.getValue_index();
            result = result * 59 + ($value_index == null ? 43 : ((Object)$value_index).hashCode());
            String $value_name = this.getValue_name();
            result = result * 59 + ($value_name == null ? 43 : $value_name.hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JDecoderValueParam(value_name=" + this.getValue_name() + ", value_index=" + this.getValue_index() + ")";
        }
    }

    public static class JDecoderParam
    implements Serializable {
        private Object updateTime = 0;
        private String sourceType = "csv";
        private String table;
        private Map<String, JDecoderValueParam> valueMap = new HashMap<String, JDecoderValueParam>();

        public Object getUpdateTime() {
            return this.updateTime;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getTable() {
            return this.table;
        }

        public Map<String, JDecoderValueParam> getValueMap() {
            return this.valueMap;
        }

        public void setUpdateTime(Object updateTime) {
            this.updateTime = updateTime;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setValueMap(Map<String, JDecoderValueParam> valueMap) {
            this.valueMap = valueMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderParam)) {
                return false;
            }
            JDecoderParam other = (JDecoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$updateTime = this.getUpdateTime();
            Object other$updateTime = other.getUpdateTime();
            if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
                return false;
            }
            String this$sourceType = this.getSourceType();
            String other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Map<String, JDecoderValueParam> this$valueMap = this.getValueMap();
            Map<String, JDecoderValueParam> other$valueMap = other.getValueMap();
            return !(this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $updateTime = this.getUpdateTime();
            result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
            String $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Map<String, JDecoderValueParam> $valueMap = this.getValueMap();
            result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JDecoderParam(updateTime=" + this.getUpdateTime() + ", sourceType=" + this.getSourceType() + ", table=" + this.getTable() + ", valueMap=" + this.getValueMap() + ")";
        }
    }
}

