/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.TemplateFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocol;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocolFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteStatusRequest;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteStatusRespond;
import cn.foxtech.device.protocol.v1.modbus.template.JReadStatusTemplate;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.Map;

@FoxEdgeDeviceType(value="ModBus Device", manufacturer="Fox Edge")
public class ModBusProtocolWriteStatus {
    @FoxEdgeOperate(name="Write Single Status", polling=true, type="encoder", timeout=2000)
    public static String packWriteSingleStatus(Map<String, Object> param) {
        return (String)ModBusProtocolWriteStatus.operateWriteStatus("", param);
    }

    @FoxEdgeOperate(name="Write Single Status", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackWriteSingleStatus(String hexString, Map<String, Object> param) {
        return (Map)ModBusProtocolWriteStatus.operateWriteStatus(hexString, param);
    }

    private static Object operateWriteStatus(String hexString, Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        String modbusMode = (String)param.get("modbusMode");
        String modelName = (String)param.get("modelName");
        String objectName = (String)param.get("objectName");
        Object objectValue = param.get("objectValue");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr, modbusMode, objectName, objectValue, modelName})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:devAddr, modbusMode, objectName, objectValue");
        }
        JReadStatusTemplate template = (JReadStatusTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-modbus").getTemplate("jsn", modelName, JReadStatusTemplate.class);
        ModBusWriteStatusRequest writeStatusRequest = template.encode(objectName, objectValue);
        if (writeStatusRequest == null) {
            throw new ProtocolException("\u7f16\u7801\u5931\u8d25");
        }
        param.put("devAddr", devAddr);
        param.put("regAddr", writeStatusRequest.getMemAddr());
        param.put("regCnt", 1);
        param.put("modbusMode", modbusMode);
        ModBusProtocol protocol = ModBusProtocolFactory.createProtocol((String)modbusMode);
        if (hexString.isEmpty()) {
            byte[] pack = protocol.packCmdWriteStatus4Request(writeStatusRequest);
            return HexUtils.byteArrayToHexString((byte[])pack);
        }
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        ModBusWriteStatusRespond respond = protocol.unPackCmdWriteStatus2Respond(arrCmd);
        if (respond == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        boolean[] statusList = new boolean[]{respond.isStatus()};
        Map<String, Object> value = template.decode(respond.getMemAddr(), 1, statusList);
        return value;
    }
}

