/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.TemplateFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocol;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocolFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteRegistersRequest;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteRegistersRespond;
import cn.foxtech.device.protocol.v1.modbus.template.JReadRegistersTemplate;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.Map;

@FoxEdgeDeviceType(value="ModBus Device", manufacturer="Fox Edge")
public class ModBusProtocolWriteRegisters {
    @FoxEdgeOperate(name="Write Single Register", polling=true, type="encoder", timeout=2000)
    public static String packWriteHoldingRegister(Map<String, Object> param) {
        return (String)ModBusProtocolWriteRegisters.operateWriteRegister("", param);
    }

    @FoxEdgeOperate(name="Write Single Register", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackWriteHoldingRegister(String hexString, Map<String, Object> param) {
        return (Map)ModBusProtocolWriteRegisters.operateWriteRegister(hexString, param);
    }

    private static Object operateWriteRegister(String hexString, Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        String modbusMode = (String)param.get("modbusMode");
        String modelName = (String)param.get("modelName");
        String objectName = (String)param.get("objectName");
        Object objectValue = param.get("objectValue");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr, modbusMode, objectName, objectValue, modelName})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a: devAddr, modbusMode, objectName, objectValue, modelName");
        }
        JReadRegistersTemplate template = (JReadRegistersTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-modbus").getTemplate("jsn", modelName, JReadRegistersTemplate.class);
        ModBusWriteRegistersRequest writeRegistersRequest = template.encode(objectName, objectValue);
        if (writeRegistersRequest == null) {
            throw new ProtocolException("\u7f16\u7801\u5931\u8d25");
        }
        param.put("devAddr", devAddr);
        param.put("regAddr", writeRegistersRequest.getMemAddr());
        param.put("regCnt", 1);
        param.put("modbusMode", modbusMode);
        ModBusProtocol protocol = ModBusProtocolFactory.createProtocol((String)modbusMode);
        if (hexString.isEmpty()) {
            byte[] pack = protocol.packCmdWriteRegisters4Request(writeRegistersRequest);
            return HexUtils.byteArrayToHexString((byte[])pack);
        }
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        ModBusWriteRegistersRespond respond = protocol.unPackCmdWriteRegisters2Respond(arrCmd);
        if (respond == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        int[] statusList = new int[]{respond.getValue()};
        Map<String, Object> value = template.decode(respond.getMemAddr(), 1, statusList);
        return value;
    }
}

