/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus.template;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.ITemplate;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusWriteStatusRequest;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JReadStatusTemplate
implements ITemplate {
    public static final String READ_COIL_STATUS = "Read Coil Status";
    public static final String READ_DISCRETE_INPUT_STATUS = "Read Discrete Input Status";
    public static final String WRITE_SINGLE_STATUS = "Write Single Status";
    private String template_name = "";
    private JOperate operate = new JOperate();

    public String getSysTemplateName() {
        return "status default";
    }

    public void loadCsvFile(String table) {
        File dir = new File("");
        File file = new File(dir.getAbsolutePath() + "/template/" + table);
        CsvReader csvReader = CsvUtil.getReader();
        List rows = csvReader.read((Reader)ResourceUtil.getReader((String)file.getPath(), (Charset)CharsetUtil.CHARSET_GBK), JDecoderValueParam.class);
        HashMap<String, JDecoderValueParam> map = new HashMap<String, JDecoderValueParam>();
        for (JDecoderValueParam jDecoderValueParam : rows) {
            map.put(jDecoderValueParam.getValue_name(), jDecoderValueParam);
        }
        this.operate.decoder_param.valueMap = map;
        this.operate.decoder_param.table = table;
    }

    public Map<String, Object> decode(int address, int coilCount, boolean[] statusList) throws ProtocolException {
        return this.decodeValue(address, coilCount, statusList);
    }

    public ModBusWriteStatusRequest encode(String objectName, Object objectValue) {
        ModBusWriteStatusRequest request = new ModBusWriteStatusRequest();
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.operate.decoder_param.valueMap.get(objectName);
        if (jDecoderValueParam == null) {
            throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f");
        }
        request.setMemAddr(jDecoderValueParam.value_index.intValue());
        request.setStatus(Boolean.valueOf(objectValue.toString()).booleanValue());
        return request;
    }

    private Map<String, Object> decodeValue(int address, int count, boolean[] statusList) {
        int offsetStart = address;
        int offsetEnd = address + count - 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : this.operate.decoder_param.valueMap.entrySet()) {
            int index;
            String name = (String)entry.getKey();
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)entry.getValue();
            if (jDecoderValueParam.value_index < offsetStart || jDecoderValueParam.value_index > offsetEnd + 1 || (index = jDecoderValueParam.value_index - offsetStart) >= statusList.length) continue;
            boolean status = statusList[index];
            result.put(name, status);
        }
        return result;
    }

    private int binary(int pos) {
        int value = 1;
        while (pos-- >= 0) {
            value *= 2;
        }
        return value / 2;
    }

    public String getTemplate_name() {
        return this.template_name;
    }

    public JOperate getOperate() {
        return this.operate;
    }

    public void setTemplate_name(String template_name) {
        this.template_name = template_name;
    }

    public void setOperate(JOperate operate) {
        this.operate = operate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JReadStatusTemplate)) {
            return false;
        }
        JReadStatusTemplate other = (JReadStatusTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$template_name = this.getTemplate_name();
        String other$template_name = other.getTemplate_name();
        if (this$template_name == null ? other$template_name != null : !this$template_name.equals(other$template_name)) {
            return false;
        }
        JOperate this$operate = this.getOperate();
        JOperate other$operate = other.getOperate();
        return !(this$operate == null ? other$operate != null : !((Object)this$operate).equals(other$operate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JReadStatusTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $template_name = this.getTemplate_name();
        result = result * 59 + ($template_name == null ? 43 : $template_name.hashCode());
        JOperate $operate = this.getOperate();
        result = result * 59 + ($operate == null ? 43 : ((Object)$operate).hashCode());
        return result;
    }

    public String toString() {
        return "JReadStatusTemplate(template_name=" + this.getTemplate_name() + ", operate=" + this.getOperate() + ")";
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String value_name;
        private Integer value_index;

        public String getValue_name() {
            return this.value_name;
        }

        public Integer getValue_index() {
            return this.value_index;
        }

        public void setValue_name(String value_name) {
            this.value_name = value_name;
        }

        public void setValue_index(Integer value_index) {
            this.value_index = value_index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$value_index = this.getValue_index();
            Integer other$value_index = other.getValue_index();
            if (this$value_index == null ? other$value_index != null : !((Object)this$value_index).equals(other$value_index)) {
                return false;
            }
            String this$value_name = this.getValue_name();
            String other$value_name = other.getValue_name();
            return !(this$value_name == null ? other$value_name != null : !this$value_name.equals(other$value_name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $value_index = this.getValue_index();
            result = result * 59 + ($value_index == null ? 43 : ((Object)$value_index).hashCode());
            String $value_name = this.getValue_name();
            result = result * 59 + ($value_name == null ? 43 : $value_name.hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JDecoderValueParam(value_name=" + this.getValue_name() + ", value_index=" + this.getValue_index() + ")";
        }
    }

    public static class JDecoderParam
    implements Serializable {
        private String table;
        private Map<String, JDecoderValueParam> valueMap = new HashMap<String, JDecoderValueParam>();

        public String getTable() {
            return this.table;
        }

        public Map<String, JDecoderValueParam> getValueMap() {
            return this.valueMap;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setValueMap(Map<String, JDecoderValueParam> valueMap) {
            this.valueMap = valueMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderParam)) {
                return false;
            }
            JDecoderParam other = (JDecoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Map<String, JDecoderValueParam> this$valueMap = this.getValueMap();
            Map<String, JDecoderValueParam> other$valueMap = other.getValueMap();
            return !(this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Map<String, JDecoderValueParam> $valueMap = this.getValueMap();
            result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JDecoderParam(table=" + this.getTable() + ", valueMap=" + this.getValueMap() + ")";
        }
    }

    public static class JEncoderParam
    implements Serializable {
        private String reg_addr;
        private Integer reg_cnt;

        public String getReg_addr() {
            return this.reg_addr;
        }

        public Integer getReg_cnt() {
            return this.reg_cnt;
        }

        public void setReg_addr(String reg_addr) {
            this.reg_addr = reg_addr;
        }

        public void setReg_cnt(Integer reg_cnt) {
            this.reg_cnt = reg_cnt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JEncoderParam)) {
                return false;
            }
            JEncoderParam other = (JEncoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$reg_cnt = this.getReg_cnt();
            Integer other$reg_cnt = other.getReg_cnt();
            if (this$reg_cnt == null ? other$reg_cnt != null : !((Object)this$reg_cnt).equals(other$reg_cnt)) {
                return false;
            }
            String this$reg_addr = this.getReg_addr();
            String other$reg_addr = other.getReg_addr();
            return !(this$reg_addr == null ? other$reg_addr != null : !this$reg_addr.equals(other$reg_addr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JEncoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $reg_cnt = this.getReg_cnt();
            result = result * 59 + ($reg_cnt == null ? 43 : ((Object)$reg_cnt).hashCode());
            String $reg_addr = this.getReg_addr();
            result = result * 59 + ($reg_addr == null ? 43 : $reg_addr.hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JEncoderParam(reg_addr=" + this.getReg_addr() + ", reg_cnt=" + this.getReg_cnt() + ")";
        }
    }

    public static class JOperate
    implements Serializable {
        private String name = "";
        private String operate_name = "";
        private String modbus_mode = "";
        private JEncoderParam encoder_param = new JEncoderParam();
        private JDecoderParam decoder_param = new JDecoderParam();

        public String getName() {
            return this.name;
        }

        public String getOperate_name() {
            return this.operate_name;
        }

        public String getModbus_mode() {
            return this.modbus_mode;
        }

        public JEncoderParam getEncoder_param() {
            return this.encoder_param;
        }

        public JDecoderParam getDecoder_param() {
            return this.decoder_param;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOperate_name(String operate_name) {
            this.operate_name = operate_name;
        }

        public void setModbus_mode(String modbus_mode) {
            this.modbus_mode = modbus_mode;
        }

        public void setEncoder_param(JEncoderParam encoder_param) {
            this.encoder_param = encoder_param;
        }

        public void setDecoder_param(JDecoderParam decoder_param) {
            this.decoder_param = decoder_param;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JOperate)) {
                return false;
            }
            JOperate other = (JOperate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$operate_name = this.getOperate_name();
            String other$operate_name = other.getOperate_name();
            if (this$operate_name == null ? other$operate_name != null : !this$operate_name.equals(other$operate_name)) {
                return false;
            }
            String this$modbus_mode = this.getModbus_mode();
            String other$modbus_mode = other.getModbus_mode();
            if (this$modbus_mode == null ? other$modbus_mode != null : !this$modbus_mode.equals(other$modbus_mode)) {
                return false;
            }
            JEncoderParam this$encoder_param = this.getEncoder_param();
            JEncoderParam other$encoder_param = other.getEncoder_param();
            if (this$encoder_param == null ? other$encoder_param != null : !((Object)this$encoder_param).equals(other$encoder_param)) {
                return false;
            }
            JDecoderParam this$decoder_param = this.getDecoder_param();
            JDecoderParam other$decoder_param = other.getDecoder_param();
            return !(this$decoder_param == null ? other$decoder_param != null : !((Object)this$decoder_param).equals(other$decoder_param));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JOperate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $operate_name = this.getOperate_name();
            result = result * 59 + ($operate_name == null ? 43 : $operate_name.hashCode());
            String $modbus_mode = this.getModbus_mode();
            result = result * 59 + ($modbus_mode == null ? 43 : $modbus_mode.hashCode());
            JEncoderParam $encoder_param = this.getEncoder_param();
            result = result * 59 + ($encoder_param == null ? 43 : ((Object)$encoder_param).hashCode());
            JDecoderParam $decoder_param = this.getDecoder_param();
            result = result * 59 + ($decoder_param == null ? 43 : ((Object)$decoder_param).hashCode());
            return result;
        }

        public String toString() {
            return "JReadStatusTemplate.JOperate(name=" + this.getName() + ", operate_name=" + this.getOperate_name() + ", modbus_mode=" + this.getModbus_mode() + ", encoder_param=" + this.getEncoder_param() + ", decoder_param=" + this.getDecoder_param() + ")";
        }
    }
}

