/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.TemplateFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocol;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocolFactory;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusReadStatusRespond;
import cn.foxtech.device.protocol.v1.modbus.template.JReadStatusTemplate;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.Map;

@FoxEdgeDeviceType(value="ModBus Device", manufacturer="Fox Edge")
public class ModBusProtocolReadStatus {
    @FoxEdgeOperate(name="Read Coil Status", polling=true, type="encoder", timeout=2000)
    public static String packReadCoilStatus(Map<String, Object> param) {
        return (String)ModBusProtocolReadStatus.operateReadStatus("", "Read Coil Status", param);
    }

    @FoxEdgeOperate(name="Read Coil Status", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadCoilStatus(String hexString, Map<String, Object> param) {
        return (Map)ModBusProtocolReadStatus.operateReadStatus(hexString, "Read Coil Status", param);
    }

    @FoxEdgeOperate(name="Read Discrete Inputs Status", polling=true, type="encoder", timeout=2000)
    public static String packReadInputStatus(Map<String, Object> param) {
        return (String)ModBusProtocolReadStatus.operateReadStatus("", "Read Discrete Input Status", param);
    }

    @FoxEdgeOperate(name="Read Discrete Inputs Status", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadInputStatus(String hexString, Map<String, Object> param) {
        return (Map)ModBusProtocolReadStatus.operateReadStatus(hexString, "Read Discrete Input Status", param);
    }

    private static Object operateReadStatus(String hexString, String operateName, Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        Integer regAddr = (Integer)param.get("regAddr");
        Integer regCnt = (Integer)param.get("regCnt");
        String modbusMode = (String)param.get("modbusMode");
        String templateName = (String)param.get("templateName");
        String tableName = (String)param.get("tableName");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr, regAddr, regCnt, modbusMode, templateName, tableName})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:devAddr, regAddr, regCnd, modbusMode, templateName, tableName");
        }
        JReadStatusTemplate template = (JReadStatusTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-modbus").getTemplate(templateName, tableName, JReadStatusTemplate.class);
        Byte func = 0;
        if ("Read Coil Status".equals(operateName)) {
            func = 1;
        }
        if ("Read Discrete Input Status".equals(operateName)) {
            func = 2;
        }
        param.put("devAddr", devAddr);
        param.put("regAddr", regAddr);
        param.put("regCnt", regCnt);
        param.put("modbusMode", modbusMode);
        ModBusProtocol protocol = ModBusProtocolFactory.createProtocol((String)modbusMode);
        if (hexString.isEmpty()) {
            byte[] pack = protocol.packCmdReadStatus4Map(func.byteValue(), param);
            return HexUtils.byteArrayToHexString((byte[])pack);
        }
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        ModBusReadStatusRespond respond = protocol.unPackCmdReadStatus2Respond(arrCmd);
        if (respond == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        return template.decode(regAddr, regCnt, respond.getStatus());
    }
}

