/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus.core;

import cn.foxtech.device.protocol.v1.modbus.core.ModBusEntity;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocol;
import cn.foxtech.device.protocol.v1.utils.Crc16Utils;
import cn.foxtech.device.protocol.v1.utils.enums.CrcType;
import java.util.HashMap;
import java.util.Map;

public class ModBusRtuProtocol
extends ModBusProtocol {
    @Override
    public byte[] packCmd4Map(Map<String, Object> param) {
        if (!super.checkParam(param)) {
            return null;
        }
        ModBusEntity entity = new ModBusEntity();
        entity.setDevAddr(Integer.decode(param.get("devAddr").toString()).byteValue());
        entity.setFunc(Integer.decode(param.get("func").toString()).byteValue());
        entity.setData((byte[])param.get("data"));
        return this.packCmd4Entity(entity);
    }

    @Override
    public ModBusEntity unPackCmd2Entity(byte[] arrCmd) {
        ModBusEntity entity = new ModBusEntity();
        int iSize = arrCmd.length;
        if (iSize < 4) {
            return null;
        }
        byte byAddr = arrCmd[0];
        entity.setDevAddr(byAddr);
        byte byFun = arrCmd[1];
        entity.setFunc(byFun);
        int iDataSize = iSize - 4;
        entity.setData(new byte[iDataSize]);
        byte[] arrData = entity.getData();
        System.arraycopy(arrCmd, 2, arrData, 0, iDataSize);
        int wCrc16OK = Crc16Utils.getCRC16((byte[])arrCmd, (int)0, (int)(arrCmd.length - 2), (CrcType)CrcType.CRC16MODBUS);
        byte crcH = (byte)(wCrc16OK & 0xFF);
        byte crcL = (byte)((wCrc16OK & 0xFF00) >> 8);
        if (arrCmd[arrCmd.length - 1] == crcL && arrCmd[arrCmd.length - 2] == crcH) {
            return entity;
        }
        return null;
    }

    @Override
    public Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("devAddr", entity.getDevAddr());
        value.put("func", entity.getFunc());
        value.put("data", entity.getData());
        return value;
    }

    @Override
    public byte[] packCmd4Entity(ModBusEntity entity) {
        int iSize = entity.getData().length;
        byte[] arrCmd = new byte[iSize + 4];
        arrCmd[0] = entity.getDevAddr();
        arrCmd[1] = entity.getFunc();
        System.arraycopy(entity.getData(), 0, arrCmd, 2, iSize);
        int wCrc16 = Crc16Utils.getCRC16((byte[])arrCmd, (int)0, (int)(arrCmd.length - 2), (CrcType)CrcType.CRC16MODBUS);
        arrCmd[arrCmd.length - 2] = (byte)(wCrc16 % 256);
        arrCmd[arrCmd.length - 1] = (byte)(wCrc16 / 256);
        return arrCmd;
    }
}

