/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.modbus.core;

import cn.foxtech.device.protocol.v1.modbus.core.ModBusEntity;
import cn.foxtech.device.protocol.v1.modbus.core.ModBusProtocol;
import java.util.HashMap;
import java.util.Map;

public class ModBusTcpProtocol
extends ModBusProtocol {
    @Override
    public ModBusEntity unPackCmd2Entity(byte[] arrCmd) {
        ModBusEntity entity = new ModBusEntity();
        int wSn = (arrCmd[0] & 0xFF) * 256;
        entity.setSn((short)((wSn += arrCmd[1] & 0xFF) & 0xFFFF));
        if (arrCmd[2] != 0 || arrCmd[3] != 0) {
            return null;
        }
        int len = (arrCmd[4] & 0xFF) * 256;
        if (arrCmd.length != (len += arrCmd[5] & 0xFF) + 6) {
            return null;
        }
        if (len < 2) {
            return null;
        }
        entity.setDevAddr(arrCmd[6]);
        entity.setFunc(arrCmd[7]);
        byte[] arrData = new byte[len - 2];
        System.arraycopy(arrCmd, 8, arrData, 0, arrData.length);
        entity.setData(arrData);
        return entity;
    }

    @Override
    public byte[] packCmd4Entity(ModBusEntity entity) {
        byte[] arrCmd = new byte[entity.getData().length + 8];
        arrCmd[0] = (byte)((entity.getSn() & 0xFF00) >> 8);
        arrCmd[1] = (byte)(entity.getSn() & 0xFF);
        arrCmd[2] = 0;
        arrCmd[3] = 0;
        int len = entity.getData().length + 2;
        arrCmd[4] = (byte)((len & 0xFF00) >> 8);
        arrCmd[5] = (byte)(len & 0xFF);
        arrCmd[6] = entity.getDevAddr();
        arrCmd[7] = entity.getFunc();
        System.arraycopy(entity.getData(), 0, arrCmd, 8, entity.getData().length);
        return arrCmd;
    }

    @Override
    public boolean checkParam(Map<String, Object> param) {
        if (!super.checkParam(param)) {
            return false;
        }
        return param.containsKey("sn") && param.get("sn") instanceof Integer;
    }

    @Override
    public byte[] packCmd4Map(Map<String, Object> param) {
        if (!this.checkParam(param)) {
            return null;
        }
        ModBusEntity entity = new ModBusEntity();
        entity.setSn(Integer.decode(param.get("sn").toString()));
        entity.setDevAddr(Integer.decode(param.get("devAddr").toString()).byteValue());
        entity.setFunc(Integer.decode(param.get("func").toString()).byteValue());
        entity.setData((byte[])param.get("data"));
        return this.packCmd4Entity(entity);
    }

    @Override
    public Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("sn", entity.getSn());
        value.put("devAddr", entity.getDevAddr());
        value.put("func", entity.getFunc());
        value.put("data", entity.getData());
        return value;
    }
}

