/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.modbus.core;

import cn.foxtech.device.protocol.core.reference.ByteRef;
import cn.foxtech.device.protocol.core.reference.BytesRef;
import cn.foxtech.device.protocol.core.reference.IntegerRef;
import cn.foxtech.device.protocol.modbus.core.ModBusEntity;
import cn.foxtech.device.protocol.modbus.core.ModBusProtocol;
import java.util.HashMap;
import java.util.Map;

public class ModBusAsciiProtocol
extends ModBusProtocol {
    private static void hexToAscii(byte byAt, ByteRef chAsciiHValue, ByteRef chAsciiLValue) {
        byte chAsciiH = 0;
        byte chAsciiL = 0;
        switch (byAt & 0xF0) {
            case 0: {
                chAsciiH = 48;
                break;
            }
            case 16: {
                chAsciiH = 49;
                break;
            }
            case 32: {
                chAsciiH = 50;
                break;
            }
            case 48: {
                chAsciiH = 51;
                break;
            }
            case 64: {
                chAsciiH = 52;
                break;
            }
            case 80: {
                chAsciiH = 53;
                break;
            }
            case 96: {
                chAsciiH = 54;
                break;
            }
            case 112: {
                chAsciiH = 55;
                break;
            }
            case 128: {
                chAsciiH = 56;
                break;
            }
            case 144: {
                chAsciiH = 57;
                break;
            }
            case 160: {
                chAsciiH = 65;
                break;
            }
            case 176: {
                chAsciiH = 66;
                break;
            }
            case 192: {
                chAsciiH = 67;
                break;
            }
            case 208: {
                chAsciiH = 68;
                break;
            }
            case 224: {
                chAsciiH = 69;
                break;
            }
            case 240: {
                chAsciiH = 70;
                break;
            }
            default: {
                return;
            }
        }
        switch (byAt & 0xF) {
            case 0: {
                chAsciiL = 48;
                break;
            }
            case 1: {
                chAsciiL = 49;
                break;
            }
            case 2: {
                chAsciiL = 50;
                break;
            }
            case 3: {
                chAsciiL = 51;
                break;
            }
            case 4: {
                chAsciiL = 52;
                break;
            }
            case 5: {
                chAsciiL = 53;
                break;
            }
            case 6: {
                chAsciiL = 54;
                break;
            }
            case 7: {
                chAsciiL = 55;
                break;
            }
            case 8: {
                chAsciiL = 56;
                break;
            }
            case 9: {
                chAsciiL = 57;
                break;
            }
            case 10: {
                chAsciiL = 65;
                break;
            }
            case 11: {
                chAsciiL = 66;
                break;
            }
            case 12: {
                chAsciiL = 67;
                break;
            }
            case 13: {
                chAsciiL = 68;
                break;
            }
            case 14: {
                chAsciiL = 69;
                break;
            }
            case 15: {
                chAsciiL = 70;
                break;
            }
            default: {
                return;
            }
        }
        chAsciiHValue.setValue(chAsciiH);
        chAsciiLValue.setValue(chAsciiL);
    }

    private static boolean getLRC8(byte[] arrCmd, IntegerRef wLRC8Value) {
        int iSize = arrCmd.length - 5;
        if (iSize < 4) {
            return false;
        }
        if (iSize % 2 != 0) {
            return false;
        }
        int byAt = 1;
        ByteRef byHexAt = new ByteRef();
        int uchLRC = 0;
        do {
            int n = byAt;
            byAt = (byte)(byAt + 1);
            byte chHigh = arrCmd[n];
            int n2 = byAt;
            byAt = (byte)(byAt + 1);
            byte chLow = arrCmd[n2];
            if (!ModBusAsciiProtocol.asciiToHex(chHigh, chLow, byHexAt)) {
                return false;
            }
            uchLRC += byHexAt.getValue();
        } while ((iSize -= 2) > 0);
        byte byLRC = (byte)(-((char)(uchLRC &= 0xFF)));
        ByteRef chHighValue = new ByteRef();
        ByteRef chLowValue = new ByteRef();
        ModBusAsciiProtocol.hexToAscii(byLRC, chHighValue, chLowValue);
        wLRC8Value.setValue((int)((short)((short)chHighValue.getValue() << 8 | chLowValue.getValue())));
        return true;
    }

    private static boolean asciiToHex(byte chAsciiH, byte chAsciiL, ByteRef byAt) {
        byte byAtH = 0;
        byte byAtL = 0;
        if (chAsciiH >= 48 && chAsciiH <= 57) {
            byAtH = (byte)(chAsciiH - 48);
        } else if (chAsciiH >= 65 && chAsciiH <= 70) {
            byAtH = (byte)(chAsciiH - 55);
        } else {
            return false;
        }
        if (chAsciiL >= 48 && chAsciiL <= 57) {
            byAtL = (byte)(chAsciiL - 48);
        } else if (chAsciiL >= 65 && chAsciiL <= 70) {
            byAtL = (byte)(chAsciiL - 55);
        } else {
            return false;
        }
        byAt.setValue((byte)((byAtH << 4) + byAtL));
        return true;
    }

    @Override
    public byte[] packCmd4Map(Map<String, Object> param) {
        if (!super.checkParam(param)) {
            return null;
        }
        ModBusEntity entity = new ModBusEntity();
        entity.setDevAddr(Byte.decode(param.get("ADDR").toString()));
        entity.setFunc(Byte.decode(param.get("FUNC").toString()));
        entity.setData((byte[])param.get("DATA"));
        return this.packCmd4Entity(entity);
    }

    @Override
    public Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("ADDR", entity.getDevAddr());
        value.put("FUNC", entity.getFunc());
        value.put("DATA", entity.getData());
        return value;
    }

    @Override
    public byte[] packCmd4Entity(ModBusEntity entity) {
        int byAt;
        int iDataSize = entity.getData().length;
        byte[] arrCmd = new byte[2 * iDataSize + 9];
        ByteRef chHighAsciiValue = new ByteRef();
        ByteRef chLowAsciiValue = new ByteRef();
        int n = byAt = 0;
        byAt = (byte)(byAt + 1);
        arrCmd[n] = 58;
        ModBusAsciiProtocol.hexToAscii(entity.getDevAddr(), chHighAsciiValue, chLowAsciiValue);
        int n2 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n2] = chHighAsciiValue.getValue();
        int n3 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n3] = chLowAsciiValue.getValue();
        ModBusAsciiProtocol.hexToAscii(entity.getFunc(), chHighAsciiValue, chLowAsciiValue);
        int n4 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n4] = chHighAsciiValue.getValue();
        int n5 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n5] = chLowAsciiValue.getValue();
        for (int i = 0; i < iDataSize; ++i) {
            ModBusAsciiProtocol.hexToAscii(entity.getData()[i], chHighAsciiValue, chLowAsciiValue);
            int n6 = byAt;
            byAt = (byte)(byAt + 1);
            arrCmd[n6] = chHighAsciiValue.getValue();
            int n7 = byAt;
            byAt = (byte)(byAt + 1);
            arrCmd[n7] = chLowAsciiValue.getValue();
        }
        IntegerRef wLRC8 = new IntegerRef();
        if (!ModBusAsciiProtocol.getLRC8(arrCmd, wLRC8)) {
            return null;
        }
        int n8 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n8] = (byte)(wLRC8.getValue() / 256);
        int n9 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n9] = (byte)(wLRC8.getValue() % 256);
        int n10 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n10] = 13;
        int n11 = byAt;
        byAt = (byte)(byAt + 1);
        arrCmd[n11] = 10;
        return arrCmd;
    }

    public byte[] packCmd4Map(Map<String, Object> param, BytesRef arrCmd) {
        if (!this.checkParam(param)) {
            return null;
        }
        byte byAddr = Byte.decode(param.get("ADDR").toString());
        byte byFunc = Byte.decode(param.get("FUNC").toString());
        byte[] arrData = (byte[])param.get("DATA");
        ModBusEntity entity = new ModBusEntity();
        entity.setDevAddr(byAddr);
        entity.setFunc(byFunc);
        entity.setData(arrData);
        return this.packCmd4Entity(entity);
    }

    @Override
    public ModBusEntity unPackCmd2Entity(byte[] arrCmd) {
        ModBusEntity entity = new ModBusEntity();
        int iSize = arrCmd.length;
        if (iSize < 9) {
            return null;
        }
        if (iSize % 2 != 1) {
            return null;
        }
        int byArrCmd = 1;
        byte chHigh = 0;
        byte chLow = 0;
        if (arrCmd[0] != 58) {
            return null;
        }
        if (arrCmd[iSize - 2] != 13) {
            return null;
        }
        if (arrCmd[iSize - 1] != 10) {
            return null;
        }
        int n = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        chHigh = arrCmd[n];
        int n2 = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        chLow = arrCmd[n2];
        ByteRef byAddrValue = new ByteRef();
        if (!ModBusAsciiProtocol.asciiToHex(chHigh, chLow, byAddrValue)) {
            return null;
        }
        entity.setDevAddr(byAddrValue.getValue());
        int n3 = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        chHigh = arrCmd[n3];
        int n4 = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        chLow = arrCmd[n4];
        ByteRef byFunValue = new ByteRef();
        if (!ModBusAsciiProtocol.asciiToHex(chHigh, chLow, byFunValue)) {
            return null;
        }
        entity.setFunc(byFunValue.getValue());
        int iDataSize = (iSize - 9) / 2;
        entity.setData(new byte[iDataSize]);
        byte[] arrData = entity.getData();
        int byAt = 0;
        ByteRef byAtValue = new ByteRef();
        for (int i = 0; i < iDataSize; ++i) {
            int n5 = byArrCmd;
            byArrCmd = (byte)(byArrCmd + 1);
            chHigh = arrCmd[n5];
            int n6 = byArrCmd;
            byArrCmd = (byte)(byArrCmd + 1);
            chLow = arrCmd[n6];
            if (!ModBusAsciiProtocol.asciiToHex(chHigh, chLow, byAtValue)) {
                return null;
            }
            int n7 = byAt;
            byAt = (byte)(byAt + 1);
            arrData[n7] = byAtValue.getValue();
        }
        int n8 = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        int wVfy = arrCmd[n8] * 256;
        int n9 = byArrCmd;
        byArrCmd = (byte)(byArrCmd + 1);
        wVfy += arrCmd[n9];
        IntegerRef wVfyOKValue = new IntegerRef();
        if (!ModBusAsciiProtocol.getLRC8(arrCmd, wVfyOKValue)) {
            return null;
        }
        if (wVfyOKValue.getValue() != wVfy) {
            return null;
        }
        return entity;
    }
}

