/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.modbus.core;

import cn.foxtech.device.protocol.modbus.core.ModBusEntity;
import cn.foxtech.device.protocol.modbus.core.ModBusError;
import cn.foxtech.device.protocol.modbus.core.ModBusReadRegistersRequest;
import cn.foxtech.device.protocol.modbus.core.ModBusReadRegistersRespond;
import cn.foxtech.device.protocol.modbus.core.ModBusReadStatusRequest;
import cn.foxtech.device.protocol.modbus.core.ModBusReadStatusRespond;
import cn.foxtech.device.protocol.modbus.core.ModBusWriteRegistersRequest;
import cn.foxtech.device.protocol.modbus.core.ModBusWriteRegistersRespond;
import cn.foxtech.device.protocol.modbus.core.ModBusWriteStatusRequest;
import cn.foxtech.device.protocol.modbus.core.ModBusWriteStatusRespond;
import java.util.HashMap;
import java.util.Map;

public abstract class ModBusProtocol {
    public abstract byte[] packCmd4Entity(ModBusEntity var1);

    public abstract ModBusEntity unPackCmd2Entity(byte[] var1);

    public abstract byte[] packCmd4Map(Map<String, Object> var1);

    public abstract Map<String, Object> unPackCmd2Map(byte[] var1);

    public boolean checkParam(Map<String, Object> param) {
        if (!param.containsKey("ADDR") || !(param.get("ADDR") instanceof Byte) && !(param.get("ADDR") instanceof Integer)) {
            return false;
        }
        if (!param.containsKey("FUNC") || !(param.get("FUNC") instanceof Byte) && !(param.get("FUNC") instanceof Integer)) {
            return false;
        }
        return param.containsKey("DATA") && param.get("DATA") instanceof byte[];
    }

    public byte[] packCmdReadInputRegisters4Map(Map<String, Object> param) {
        return this.packCmdReadRegisters4Map((byte)4, param);
    }

    public byte[] packCmdReadHoldingRegisters4Map(Map<String, Object> param) {
        return this.packCmdReadRegisters4Map((byte)3, param);
    }

    public byte[] packCmdReadRegisters4Map(byte func, Map<String, Object> param) {
        if (!param.containsKey("mode") || !(param.get("mode") instanceof String)) {
            return null;
        }
        if (!param.containsKey("ADDR") || !(param.get("ADDR") instanceof Byte) && !(param.get("ADDR") instanceof Integer)) {
            return null;
        }
        if (!param.containsKey("REG_ADDR") || !(param.get("REG_ADDR") instanceof Byte) && !(param.get("REG_ADDR") instanceof Integer)) {
            return null;
        }
        if (!param.containsKey("REG_CNT") || !(param.get("REG_CNT") instanceof Byte) && !(param.get("REG_CNT") instanceof Integer)) {
            return null;
        }
        ModBusReadRegistersRequest request = new ModBusReadRegistersRequest();
        request.getEntity().setDevAddr(Byte.decode(param.get("ADDR").toString()));
        request.setMemAddr(Integer.decode(param.get("REG_ADDR").toString()));
        request.setCount(Integer.decode(param.get("REG_CNT").toString()));
        if (param.containsKey("SN")) {
            request.getEntity().setSn(Short.decode(param.get("SN").toString()).shortValue());
        }
        request.getEntity().setFunc(func);
        return this.packCmdReadRegisters4Request(request);
    }

    public Map<String, Object> unPackCmdReadHoldingRegisters2Map(byte[] arrCmd) {
        ModBusReadRegistersRespond respond = this.unPackCmdReadRegisters2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("ADDR", respond.getEntity().getDevAddr());
        value.put("REG_HOLD_STATUS", respond.getStatus());
        return value;
    }

    public byte[] packCmdReadCoilStatus4Map(Map<String, Object> param) {
        return this.packCmdReadStatus4Map((byte)1, param);
    }

    public byte[] packCmdReadInputStatus4Map(Map<String, Object> param) {
        return this.packCmdReadStatus4Map((byte)2, param);
    }

    public byte[] packCmdReadStatus4Map(byte func, Map<String, Object> param) {
        if (!param.containsKey("mode") || !(param.get("mode") instanceof String)) {
            return null;
        }
        if (!param.containsKey("ADDR") || !(param.get("ADDR") instanceof Byte) && !(param.get("ADDR") instanceof Integer)) {
            return null;
        }
        if (!param.containsKey("REG_ADDR") || !(param.get("REG_ADDR") instanceof Byte) && !(param.get("REG_ADDR") instanceof Integer)) {
            return null;
        }
        if (!param.containsKey("REG_CNT") || !(param.get("REG_CNT") instanceof Byte) && !(param.get("REG_CNT") instanceof Integer)) {
            return null;
        }
        ModBusReadStatusRequest request = new ModBusReadStatusRequest();
        request.getEntity().setDevAddr(Byte.decode(param.get("ADDR").toString()));
        request.setMemAddr(Integer.decode(param.get("REG_ADDR").toString()));
        request.setCount(Integer.decode(param.get("REG_CNT").toString()));
        if (param.containsKey("SN")) {
            request.getEntity().setSn(Short.decode(param.get("SN").toString()).shortValue());
        }
        request.getEntity().setFunc(func);
        return this.packCmdReadStatus4Request(request);
    }

    public byte[] packCmdReadRegisters4Request(ModBusReadRegistersRequest request) {
        byte[] arrData = new byte[]{(byte)(request.getMemAddr() / 256), (byte)(request.getMemAddr() % 256), (byte)(request.getCount() / 256), (byte)(request.getCount() % 256)};
        request.getEntity().setData(arrData);
        return this.packCmd4Entity(request.getEntity());
    }

    public ModBusReadRegistersRespond unPackCmdReadRegisters2Respond(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        ModBusReadRegistersRespond respond = new ModBusReadRegistersRespond();
        respond.setEntity(entity);
        if (respond.getEntity().getFunc() == -125 && respond.getEntity().getData().length > 0) {
            respond.getEntity().setErrCode(respond.getEntity().getData()[0]);
            respond.getEntity().setErrMsg(ModBusError.getError(respond.getEntity().getData()[0]));
            return null;
        }
        if (respond.getEntity().getFunc() != 3 && respond.getEntity().getFunc() != 4) {
            return null;
        }
        byte[] arrData = respond.getEntity().getData();
        int iDataSize = arrData.length;
        if (iDataSize < 1) {
            return null;
        }
        if ((arrData[0] & 0xFF) != iDataSize - 1) {
            return null;
        }
        if (iDataSize % 2 != 1) {
            return null;
        }
        int wCount = (iDataSize - 1) / 2;
        respond.setStatus(new int[wCount]);
        int[] arrStatus = respond.getStatus();
        int byAt = 1;
        int byStatus = 0;
        for (int i = 0; i < wCount; ++i) {
            int status = (arrData[byAt] & 0xFF) * 256;
            arrStatus[byStatus++] = status += arrData[byAt + 1] & 0xFF;
            byAt += 2;
        }
        return respond;
    }

    public byte[] packCmdWriteRegisters4Request(ModBusWriteRegistersRequest request) {
        byte[] arrData = new byte[]{(byte)(request.getMemAddr() / 256), (byte)(request.getMemAddr() % 256), (byte)(request.getValue() / 256), (byte)(request.getValue() % 256)};
        request.getEntity().setFunc((byte)6);
        request.getEntity().setData(arrData);
        return this.packCmd4Entity(request.getEntity());
    }

    public byte[] packCmdReadStatus4Request(ModBusReadStatusRequest request) {
        byte[] arrData = new byte[]{(byte)(request.getMemAddr() / 256), (byte)(request.getMemAddr() % 256), (byte)(request.getCount() / 256), (byte)(request.getCount() % 256)};
        request.getEntity().setData(arrData);
        return this.packCmd4Entity(request.getEntity());
    }

    public ModBusWriteRegistersRespond unPackCmdWriteRegisters2Respond(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        ModBusWriteRegistersRespond respond = new ModBusWriteRegistersRespond();
        respond.setEntity(entity);
        if (respond.getEntity().getFunc() == -122 && respond.getEntity().getData().length > 0) {
            respond.getEntity().setErrCode(respond.getEntity().getData()[0]);
            respond.getEntity().setErrMsg(ModBusError.getError(respond.getEntity().getData()[0]));
            return null;
        }
        if (respond.getEntity().getFunc() != 6) {
            return null;
        }
        byte[] arrData = respond.getEntity().getData();
        if (arrData.length != 4) {
            return null;
        }
        respond.setMemAddr((arrData[0] & 0xFF) * 256 + (arrData[1] & 0xFF));
        respond.setValue((arrData[2] & 0xFF) * 256 + (arrData[3] & 0xFF));
        return respond;
    }

    public ModBusReadStatusRespond unPackCmdReadStatus2Respond(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        ModBusReadStatusRespond respond = new ModBusReadStatusRespond();
        respond.setEntity(entity);
        byte byFunc = respond.getEntity().getFunc();
        if ((byFunc & 0xF0) == 128 && respond.getEntity().getData().length > 0) {
            respond.getEntity().setErrCode(respond.getEntity().getData()[0]);
            respond.getEntity().setErrMsg(ModBusError.getError(respond.getEntity().getData()[0]));
            return null;
        }
        if (byFunc != 1 && byFunc != 2) {
            return null;
        }
        byte[] arrData = respond.getEntity().getData();
        int iDataSize = arrData.length;
        if (iDataSize < 1) {
            return null;
        }
        if (arrData[0] != iDataSize - 1) {
            return null;
        }
        byte wCount = respond.getEntity().getData()[0];
        if (wCount + 1 != arrData.length) {
            return null;
        }
        respond.setStatus(new boolean[wCount * 8]);
        boolean[] arrStatus = respond.getStatus();
        int byStatus = 0;
        for (int i = 1; i < iDataSize; ++i) {
            byte byAt = arrData[i];
            byte byBit = 1;
            for (int k = 0; k < 8; ++k) {
                arrStatus[byStatus++] = (byte)(byAt & byBit) != 0;
                byBit = (byte)(byBit << 1);
            }
        }
        return respond;
    }

    public byte[] packCmdWriteStatus4Request(ModBusWriteStatusRequest request) {
        byte[] arrData = new byte[4];
        arrData[0] = (byte)(request.getMemAddr() / 256);
        arrData[1] = (byte)(request.getMemAddr() % 256);
        if (request.isStatus()) {
            arrData[2] = -1;
            arrData[3] = 0;
        } else {
            arrData[2] = 0;
            arrData[3] = 0;
        }
        request.getEntity().setData(arrData);
        request.getEntity().setFunc((byte)5);
        return this.packCmd4Entity(request.getEntity());
    }

    public ModBusWriteStatusRespond unPackCmdWriteStatus2Respond(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        ModBusWriteStatusRespond respond = new ModBusWriteStatusRespond();
        respond.setEntity(entity);
        byte byFunc = respond.getEntity().getFunc();
        if ((byFunc & 0xF0) == 128 && respond.getEntity().getData().length > 0) {
            respond.getEntity().setErrCode(respond.getEntity().getData()[0]);
            respond.getEntity().setErrMsg(ModBusError.getError(respond.getEntity().getData()[0]));
            return null;
        }
        if (byFunc != 5) {
            return null;
        }
        byte[] arrData = respond.getEntity().getData();
        int iDataSize = arrData.length;
        if (iDataSize != 4) {
            return null;
        }
        respond.setMemAddr((arrData[0] & 0xFF) * 256 + (arrData[1] & 0xFF));
        respond.setStatus((arrData[2] & 0xFF) == 255);
        return respond;
    }

    public byte[] packCmdReadCoilStatus4Request(ModBusReadStatusRequest request) {
        request.getEntity().setFunc((byte)1);
        return this.packCmdReadStatus4Request(request);
    }

    public ModBusReadStatusRespond unPackCmdReadCoilStatus2Respond(byte[] arrCmd) {
        ModBusReadStatusRespond respond = this.unPackCmdReadStatus2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() == 1) {
            return respond;
        }
        return null;
    }

    public byte[] packCmdReadInputStatus4Request(ModBusReadStatusRequest request) {
        request.getEntity().setFunc((byte)2);
        return this.packCmdReadStatus4Request(request);
    }

    public ModBusReadStatusRespond unPackCmdReadInputStatus2Respond(byte[] arrCmd) {
        ModBusReadStatusRespond respond = this.unPackCmdReadStatus2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() == 2) {
            return respond;
        }
        return null;
    }

    public byte[] packCmdReadHoldingRegisters4Request(ModBusReadRegistersRequest request) {
        request.getEntity().setFunc((byte)3);
        return this.packCmdReadRegisters4Request(request);
    }

    public byte[] packCmdReadInputRegisters4Request(ModBusReadRegistersRequest request) {
        request.getEntity().setFunc((byte)4);
        return this.packCmdReadRegisters4Request(request);
    }

    public ModBusReadRegistersRespond unPackCmdReadHoldingRegisters2Respond(byte[] arrCmd) {
        ModBusReadRegistersRespond respond = this.unPackCmdReadRegisters2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() != 3) {
            return null;
        }
        return respond;
    }

    public ModBusReadRegistersRespond unPackCmdReadInputRegisters2Respond(byte[] arrCmd) {
        ModBusReadRegistersRespond respond = this.unPackCmdReadRegisters2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() != 4) {
            return null;
        }
        return respond;
    }

    public byte[] packCmdWriteSingleCoilStatus4Request(ModBusWriteStatusRequest request) {
        request.getEntity().setFunc((byte)5);
        return this.packCmdWriteStatus4Request(request);
    }

    public ModBusWriteStatusRespond unPackCmdWriteSingleCoilStatus2Respond(byte[] arrCmd) {
        ModBusWriteStatusRespond respond = this.unPackCmdWriteStatus2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() == 5) {
            return respond;
        }
        return null;
    }

    public byte[] packCmdWriteHoldingRegisters4Request(ModBusWriteRegistersRequest request) {
        request.getEntity().setFunc((byte)6);
        return this.packCmdWriteRegisters4Request(request);
    }

    public ModBusWriteRegistersRespond unPackCmdWriteHoldingRegisters2Respond(byte[] arrCmd) {
        ModBusWriteRegistersRespond respond = this.unPackCmdWriteRegisters2Respond(arrCmd);
        if (respond == null) {
            return null;
        }
        if (respond.getEntity().getFunc() == 6) {
            return respond;
        }
        return null;
    }
}

