/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.modbus.core;

import cn.foxtech.device.protocol.modbus.core.ModBusEntity;
import cn.foxtech.device.protocol.modbus.core.ModBusProtocol;
import java.util.HashMap;
import java.util.Map;

public class ModBusRtuProtocol
extends ModBusProtocol {
    public static int getCRC16(byte[] arrCmd) {
        int iSize = arrCmd.length - 2;
        if (iSize < 2) {
            return 0;
        }
        int wCrcMathematics = 40961;
        int usCrc16 = 0;
        int byteCrc16Lo = 255;
        int byteCrc16Hi = 255;
        int byteSaveHi = 0;
        int byteSaveLo = 0;
        int byteCl = wCrcMathematics % 256;
        int byteCh = wCrcMathematics / 256;
        for (int i = 0; i < iSize; ++i) {
            byteCrc16Lo &= 0xFF;
            byteCrc16Hi &= 0xFF;
            byteSaveHi &= 0xFF;
            byteSaveLo &= 0xFF;
            byteCrc16Lo ^= arrCmd[i];
            for (int k = 0; k < 8; ++k) {
                byteSaveHi = byteCrc16Hi &= 0xFF;
                byteSaveLo = byteCrc16Lo &= 0xFF;
                byteCrc16Hi /= 2;
                byteCrc16Lo /= 2;
                if ((byteSaveHi & 1) == 1) {
                    byteCrc16Lo |= 0x80;
                }
                if ((byteSaveLo & 1) != 1) continue;
                byteCrc16Hi ^= byteCh;
                byteCrc16Lo ^= byteCl;
            }
        }
        usCrc16 = (byteCrc16Hi & 0xFF) * 256 + (byteCrc16Lo & 0xFF);
        return usCrc16;
    }

    @Override
    public byte[] packCmd4Map(Map<String, Object> param) {
        if (!super.checkParam(param)) {
            return null;
        }
        ModBusEntity entity = new ModBusEntity();
        entity.setDevAddr(Byte.decode(param.get("ADDR").toString()));
        entity.setFunc(Byte.decode(param.get("FUNC").toString()));
        entity.setData((byte[])param.get("DATA"));
        return this.packCmd4Entity(entity);
    }

    @Override
    public ModBusEntity unPackCmd2Entity(byte[] arrCmd) {
        ModBusEntity entity = new ModBusEntity();
        int iSize = arrCmd.length;
        if (iSize < 4) {
            return null;
        }
        byte byAddr = arrCmd[0];
        entity.setDevAddr(byAddr);
        byte byFun = arrCmd[1];
        entity.setFunc(byFun);
        int iDataSize = iSize - 4;
        entity.setData(new byte[iDataSize]);
        byte[] arrData = entity.getData();
        System.arraycopy(arrCmd, 2, arrData, 0, iDataSize);
        int wCrc16OK = ModBusRtuProtocol.getCRC16(arrCmd);
        byte crcH = (byte)(wCrc16OK & 0xFF);
        byte crcL = (byte)((wCrc16OK & 0xFF00) >> 8);
        if (arrCmd[arrCmd.length - 1] == crcL && arrCmd[arrCmd.length - 2] == crcH) {
            return entity;
        }
        return null;
    }

    @Override
    public Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        ModBusEntity entity = this.unPackCmd2Entity(arrCmd);
        if (entity == null) {
            return null;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("ADDR", entity.getDevAddr());
        value.put("FUNC", entity.getFunc());
        value.put("DATA", entity.getData());
        return value;
    }

    @Override
    public byte[] packCmd4Entity(ModBusEntity entity) {
        int iSize = entity.getData().length;
        byte[] arrCmd = new byte[iSize + 4];
        arrCmd[0] = entity.getDevAddr();
        arrCmd[1] = entity.getFunc();
        System.arraycopy(entity.getData(), 0, arrCmd, 2, iSize);
        int wCrc16 = ModBusRtuProtocol.getCRC16(arrCmd);
        arrCmd[arrCmd.length - 2] = (byte)(wCrc16 % 256);
        arrCmd[arrCmd.length - 1] = (byte)(wCrc16 / 256);
        return arrCmd;
    }
}

