/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.mitsubishi.plc.fx;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.TemplateFactory;
import cn.foxtech.device.protocol.v1.mitsubishi.plc.fx.entity.MitsubishiPlcFxDeviceReadEntity;
import cn.foxtech.device.protocol.v1.mitsubishi.plc.fx.frame.MitsubishiPlcFxProtocolFrame;
import cn.foxtech.device.protocol.v1.mitsubishi.plc.fx.template.JDefaultTemplate;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="mitsubishi-plc-fx", manufacturer="mitsubishi")
public class PlcFxProtocolDeviceRead {
    @FoxEdgeOperate(name="DEVICE READ", polling=true, type="encoder", timeout=2000)
    public static String packReadHoldingRegister(Map<String, Object> param) {
        return (String)PlcFxProtocolDeviceRead.operateReadRegister("", param);
    }

    @FoxEdgeOperate(name="DEVICE READ", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadHoldingRegister(String hexString, Map<String, Object> param) {
        return (Map)PlcFxProtocolDeviceRead.operateReadRegister(hexString, param);
    }

    private static Object operateReadRegister(String hexString, Map<String, Object> param) {
        String target = (String)param.get("target");
        Integer address = (Integer)param.get("address");
        Integer count = (Integer)param.get("count");
        String templateName = (String)param.get("templateName");
        if (MethodUtils.hasEmpty((Object[])new Object[]{target, address, count, templateName})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:operateName, target, address, count, templateName");
        }
        MitsubishiPlcFxDeviceReadEntity entity = new MitsubishiPlcFxDeviceReadEntity();
        entity.setTarget(target);
        entity.setAddress(address.intValue());
        entity.setCount(count.intValue());
        if (hexString.isEmpty()) {
            byte[] pack = MitsubishiPlcFxProtocolFrame.encodePack((MitsubishiPlcFxDeviceReadEntity)entity);
            return HexUtils.byteArrayToHexString((byte[])pack);
        }
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        MitsubishiPlcFxProtocolFrame.decodePack((byte[])pack, (MitsubishiPlcFxDeviceReadEntity)entity);
        JDefaultTemplate template = (JDefaultTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-mitsubishi-plc-fx").getTemplate("jsn", templateName, JDefaultTemplate.class);
        template.decode(address, count, entity);
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("data", entity.getData());
        return value;
    }
}

