/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.mitsubishi.plc.fx.template;

import cn.foxtech.device.protocol.core.exception.ProtocolException;
import cn.foxtech.device.protocol.core.template.ITemplate;
import cn.foxtech.device.protocol.mitsubishi.plc.fx.entity.MitsubishiPlcFxDeviceReadEntity;
import cn.foxtech.device.protocol.modbus.core.ModBusWriteRegistersRequest;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDefaultTemplate
implements ITemplate {
    public static final String FORMAT_NAME = "default";
    private JOperate operate = new JOperate();

    public String getSysTemplateName() {
        return FORMAT_NAME;
    }

    public void setUserTemplateInfo(String userTemplateName, String tableName) {
    }

    public void loadCsvFile(String table) {
        File dir = new File("");
        File file = new File(dir.getAbsolutePath() + "/template/" + table);
        CsvReader csvReader = CsvUtil.getReader();
        List rows = csvReader.read((Reader)ResourceUtil.getReader((String)file.getPath(), (Charset)CharsetUtil.CHARSET_GBK), JDecoderValueParam.class);
        HashMap<String, JDecoderValueParam> map = new HashMap<String, JDecoderValueParam>();
        for (JDecoderValueParam jDecoderValueParam : rows) {
            map.put(jDecoderValueParam.getValue_name(), jDecoderValueParam);
        }
        this.operate.decoder_param.valueMap = map;
        this.operate.decoder_param.table = table;
    }

    public Map<String, Object> decode(int address, int count, MitsubishiPlcFxDeviceReadEntity entity) throws ProtocolException {
        return this.decodeValue(address, count, entity);
    }

    public ModBusWriteRegistersRequest encode(String objectName, Object objectValue) {
        ModBusWriteRegistersRequest request = new ModBusWriteRegistersRequest();
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.operate.decoder_param.valueMap.get(objectName);
        if (jDecoderValueParam == null) {
            throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f");
        }
        if (jDecoderValueParam.value_type.equals("int")) {
            request.setMemAddr(jDecoderValueParam.value_index.intValue());
            request.setValue((int)((float)Integer.valueOf(objectValue.toString()).intValue() / jDecoderValueParam.magnification.floatValue()));
        }
        if (jDecoderValueParam.value_type.equals("float")) {
            request.setMemAddr(jDecoderValueParam.value_index.intValue());
            request.setValue((int)(Float.valueOf(objectValue.toString()).floatValue() / jDecoderValueParam.magnification.floatValue()));
        }
        if (jDecoderValueParam.value_type.equals("bool")) {
            throw new ProtocolException("\u4e0d\u652f\u6301\u5bf9bool\u8fdb\u884c\u7f16\u7801\uff0c\u56e0\u4e3a\u4e00\u4e2a16\u4f4d\u5bc4\u5b58\u5668\u53ef\u80fd\u662f\u591a\u4e2abool\u5728\u5f7c\u6b64\u5171\u4eab");
        }
        return request;
    }

    private Map<String, Object> decodeValue(int address, int count, MitsubishiPlcFxDeviceReadEntity entity) {
        int offsetStart = address;
        int offsetEnd = address + count - 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : this.operate.decoder_param.valueMap.entrySet()) {
            String name = (String)entry.getKey();
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)entry.getValue();
            if (!entity.getTarget().equals(jDecoderValueParam.value_target) || jDecoderValueParam.value_index < offsetStart || jDecoderValueParam.value_index > offsetEnd + 1) continue;
            int index = jDecoderValueParam.value_index - offsetStart;
            int status = 0;
            if (jDecoderValueParam.value_type.equals("int")) {
                result.put(name, (int)((float)status * jDecoderValueParam.magnification.floatValue()));
            }
            if (jDecoderValueParam.value_type.equals("float")) {
                result.put(name, Float.valueOf((float)status * jDecoderValueParam.magnification.floatValue()));
            }
            if (jDecoderValueParam.value_type.equals("string")) {
                result.put(name, status);
            }
            if (!jDecoderValueParam.value_type.equals("bool")) continue;
            int value = 0;
            for (int i = 0; i < jDecoderValueParam.bit_length; ++i) {
                value += status & this.binary(jDecoderValueParam.bit_index + i);
            }
            if (jDecoderValueParam.determine.equals(">0")) {
                result.put(name, value > 0);
                continue;
            }
            result.put(name, value == 0);
        }
        return result;
    }

    private int binary(int pos) {
        int value = 1;
        while (pos-- >= 0) {
            value *= 2;
        }
        return value / 2;
    }

    public JOperate getOperate() {
        return this.operate;
    }

    public void setOperate(JOperate operate) {
        this.operate = operate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JDefaultTemplate)) {
            return false;
        }
        JDefaultTemplate other = (JDefaultTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JOperate this$operate = this.getOperate();
        JOperate other$operate = other.getOperate();
        return !(this$operate == null ? other$operate != null : !((Object)this$operate).equals(other$operate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JDefaultTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JOperate $operate = this.getOperate();
        result = result * 59 + ($operate == null ? 43 : ((Object)$operate).hashCode());
        return result;
    }

    public String toString() {
        return "JDefaultTemplate(operate=" + this.getOperate() + ")";
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String value_name;
        private String value_target;
        private Integer value_index;
        private Integer bit_index;
        private Integer bit_length;
        private String value_type;
        private Float magnification;
        private String determine;

        public String getValue_name() {
            return this.value_name;
        }

        public String getValue_target() {
            return this.value_target;
        }

        public Integer getValue_index() {
            return this.value_index;
        }

        public Integer getBit_index() {
            return this.bit_index;
        }

        public Integer getBit_length() {
            return this.bit_length;
        }

        public String getValue_type() {
            return this.value_type;
        }

        public Float getMagnification() {
            return this.magnification;
        }

        public String getDetermine() {
            return this.determine;
        }

        public void setValue_name(String value_name) {
            this.value_name = value_name;
        }

        public void setValue_target(String value_target) {
            this.value_target = value_target;
        }

        public void setValue_index(Integer value_index) {
            this.value_index = value_index;
        }

        public void setBit_index(Integer bit_index) {
            this.bit_index = bit_index;
        }

        public void setBit_length(Integer bit_length) {
            this.bit_length = bit_length;
        }

        public void setValue_type(String value_type) {
            this.value_type = value_type;
        }

        public void setMagnification(Float magnification) {
            this.magnification = magnification;
        }

        public void setDetermine(String determine) {
            this.determine = determine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$value_index = this.getValue_index();
            Integer other$value_index = other.getValue_index();
            if (this$value_index == null ? other$value_index != null : !((Object)this$value_index).equals(other$value_index)) {
                return false;
            }
            Integer this$bit_index = this.getBit_index();
            Integer other$bit_index = other.getBit_index();
            if (this$bit_index == null ? other$bit_index != null : !((Object)this$bit_index).equals(other$bit_index)) {
                return false;
            }
            Integer this$bit_length = this.getBit_length();
            Integer other$bit_length = other.getBit_length();
            if (this$bit_length == null ? other$bit_length != null : !((Object)this$bit_length).equals(other$bit_length)) {
                return false;
            }
            Float this$magnification = this.getMagnification();
            Float other$magnification = other.getMagnification();
            if (this$magnification == null ? other$magnification != null : !((Object)this$magnification).equals(other$magnification)) {
                return false;
            }
            String this$value_name = this.getValue_name();
            String other$value_name = other.getValue_name();
            if (this$value_name == null ? other$value_name != null : !this$value_name.equals(other$value_name)) {
                return false;
            }
            String this$value_target = this.getValue_target();
            String other$value_target = other.getValue_target();
            if (this$value_target == null ? other$value_target != null : !this$value_target.equals(other$value_target)) {
                return false;
            }
            String this$value_type = this.getValue_type();
            String other$value_type = other.getValue_type();
            if (this$value_type == null ? other$value_type != null : !this$value_type.equals(other$value_type)) {
                return false;
            }
            String this$determine = this.getDetermine();
            String other$determine = other.getDetermine();
            return !(this$determine == null ? other$determine != null : !this$determine.equals(other$determine));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $value_index = this.getValue_index();
            result = result * 59 + ($value_index == null ? 43 : ((Object)$value_index).hashCode());
            Integer $bit_index = this.getBit_index();
            result = result * 59 + ($bit_index == null ? 43 : ((Object)$bit_index).hashCode());
            Integer $bit_length = this.getBit_length();
            result = result * 59 + ($bit_length == null ? 43 : ((Object)$bit_length).hashCode());
            Float $magnification = this.getMagnification();
            result = result * 59 + ($magnification == null ? 43 : ((Object)$magnification).hashCode());
            String $value_name = this.getValue_name();
            result = result * 59 + ($value_name == null ? 43 : $value_name.hashCode());
            String $value_target = this.getValue_target();
            result = result * 59 + ($value_target == null ? 43 : $value_target.hashCode());
            String $value_type = this.getValue_type();
            result = result * 59 + ($value_type == null ? 43 : $value_type.hashCode());
            String $determine = this.getDetermine();
            result = result * 59 + ($determine == null ? 43 : $determine.hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JDecoderValueParam(value_name=" + this.getValue_name() + ", value_target=" + this.getValue_target() + ", value_index=" + this.getValue_index() + ", bit_index=" + this.getBit_index() + ", bit_length=" + this.getBit_length() + ", value_type=" + this.getValue_type() + ", magnification=" + this.getMagnification() + ", determine=" + this.getDetermine() + ")";
        }
    }

    public static class JDecoderParam
    implements Serializable {
        private String table;
        private Map<String, JDecoderValueParam> valueMap = new HashMap<String, JDecoderValueParam>();

        public String getTable() {
            return this.table;
        }

        public Map<String, JDecoderValueParam> getValueMap() {
            return this.valueMap;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setValueMap(Map<String, JDecoderValueParam> valueMap) {
            this.valueMap = valueMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderParam)) {
                return false;
            }
            JDecoderParam other = (JDecoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Map<String, JDecoderValueParam> this$valueMap = this.getValueMap();
            Map<String, JDecoderValueParam> other$valueMap = other.getValueMap();
            return !(this$valueMap == null ? other$valueMap != null : !((Object)this$valueMap).equals(other$valueMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Map<String, JDecoderValueParam> $valueMap = this.getValueMap();
            result = result * 59 + ($valueMap == null ? 43 : ((Object)$valueMap).hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JDecoderParam(table=" + this.getTable() + ", valueMap=" + this.getValueMap() + ")";
        }
    }

    public static class JEncoderParam
    implements Serializable {
        private String reg_addr;
        private Integer reg_cnt;

        public String getReg_addr() {
            return this.reg_addr;
        }

        public Integer getReg_cnt() {
            return this.reg_cnt;
        }

        public void setReg_addr(String reg_addr) {
            this.reg_addr = reg_addr;
        }

        public void setReg_cnt(Integer reg_cnt) {
            this.reg_cnt = reg_cnt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JEncoderParam)) {
                return false;
            }
            JEncoderParam other = (JEncoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$reg_cnt = this.getReg_cnt();
            Integer other$reg_cnt = other.getReg_cnt();
            if (this$reg_cnt == null ? other$reg_cnt != null : !((Object)this$reg_cnt).equals(other$reg_cnt)) {
                return false;
            }
            String this$reg_addr = this.getReg_addr();
            String other$reg_addr = other.getReg_addr();
            return !(this$reg_addr == null ? other$reg_addr != null : !this$reg_addr.equals(other$reg_addr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JEncoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $reg_cnt = this.getReg_cnt();
            result = result * 59 + ($reg_cnt == null ? 43 : ((Object)$reg_cnt).hashCode());
            String $reg_addr = this.getReg_addr();
            result = result * 59 + ($reg_addr == null ? 43 : $reg_addr.hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JEncoderParam(reg_addr=" + this.getReg_addr() + ", reg_cnt=" + this.getReg_cnt() + ")";
        }
    }

    public static class JOperate
    implements Serializable {
        private String name = "";
        private String operate_name = "";
        private JEncoderParam encoder_param = new JEncoderParam();
        private JDecoderParam decoder_param = new JDecoderParam();

        public String getName() {
            return this.name;
        }

        public String getOperate_name() {
            return this.operate_name;
        }

        public JEncoderParam getEncoder_param() {
            return this.encoder_param;
        }

        public JDecoderParam getDecoder_param() {
            return this.decoder_param;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOperate_name(String operate_name) {
            this.operate_name = operate_name;
        }

        public void setEncoder_param(JEncoderParam encoder_param) {
            this.encoder_param = encoder_param;
        }

        public void setDecoder_param(JDecoderParam decoder_param) {
            this.decoder_param = decoder_param;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JOperate)) {
                return false;
            }
            JOperate other = (JOperate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$operate_name = this.getOperate_name();
            String other$operate_name = other.getOperate_name();
            if (this$operate_name == null ? other$operate_name != null : !this$operate_name.equals(other$operate_name)) {
                return false;
            }
            JEncoderParam this$encoder_param = this.getEncoder_param();
            JEncoderParam other$encoder_param = other.getEncoder_param();
            if (this$encoder_param == null ? other$encoder_param != null : !((Object)this$encoder_param).equals(other$encoder_param)) {
                return false;
            }
            JDecoderParam this$decoder_param = this.getDecoder_param();
            JDecoderParam other$decoder_param = other.getDecoder_param();
            return !(this$decoder_param == null ? other$decoder_param != null : !((Object)this$decoder_param).equals(other$decoder_param));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JOperate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $operate_name = this.getOperate_name();
            result = result * 59 + ($operate_name == null ? 43 : $operate_name.hashCode());
            JEncoderParam $encoder_param = this.getEncoder_param();
            result = result * 59 + ($encoder_param == null ? 43 : ((Object)$encoder_param).hashCode());
            JDecoderParam $decoder_param = this.getDecoder_param();
            result = result * 59 + ($decoder_param == null ? 43 : ((Object)$decoder_param).hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JOperate(name=" + this.getName() + ", operate_name=" + this.getOperate_name() + ", encoder_param=" + this.getEncoder_param() + ", decoder_param=" + this.getDecoder_param() + ")";
        }
    }
}

