/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.lrw;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.lrw.LRWEntity;
import cn.foxtech.device.protocol.v1.lrw.LRWProtocolFrame;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="LRW\u89e3\u7801\u5668", manufacturer="Fox-Edge")
public class LRWProtocolGetSensor
extends LRWProtocolFrame {
    @FoxEdgeOperate(name="\u67e5\u8be2\u4f20\u611f\u5668\u72b6\u6001", polling=true, type="encoder")
    public static String encodePackSensor(Map<String, Object> param) {
        return HexUtils.byteArrayToHexString((byte[])LRWProtocolGetSensor.encodePack((byte)2));
    }

    @FoxEdgeOperate(name="\u67e5\u8be2\u4f20\u611f\u5668\u72b6\u6001", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> decodePackSensor(String hexString, Map<String, Object> param) {
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        LRWEntity entity = LRWProtocolGetSensor.decodePack(pack);
        if (entity == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (entity.getCmd() != -126) {
            throw new ProtocolException("\u8bbe\u5907\u62d2\u7edd\uff01");
        }
        byte[] dat = entity.getDat();
        boolean sample = dat[0] != 0;
        boolean plate = dat[1] != 0;
        boolean stick = dat[2] != 0;
        boolean interval = dat[3] != 0;
        boolean spark = dat[4] != 0;
        boolean box = dat[5] != 0;
        int tempH = dat[6] & 0xFF;
        int tempL = dat[7] & 0xFF;
        int temp = (tempH * 256 + tempL) / 10;
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("sample", sample);
        value.put("plate", plate);
        value.put("stick", stick);
        value.put("interval", interval);
        value.put("spark", spark);
        value.put("box", box);
        value.put("temp", temp);
        return value;
    }
}

