/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.lrw;

import cn.foxtech.device.protocol.lrw.LRWEntity;

public class LRWProtocolFrame {
    public static byte[] encodePack(byte cmd, byte[] dat) {
        byte[] pack = new byte[dat.length + 5];
        pack[0] = -80;
        pack[1] = cmd;
        pack[2] = (byte)dat.length;
        for (int i = 0; i < dat.length; ++i) {
            pack[3 + i] = dat[i];
        }
        pack[dat.length + 3] = -2;
        pack[dat.length + 4] = -2;
        return pack;
    }

    public static LRWEntity decodePack(byte[] pack) {
        if (pack.length < 5) {
            return null;
        }
        if (pack[0] != -80) {
            return null;
        }
        LRWEntity entity = new LRWEntity();
        entity.setCmd(pack[1]);
        if ((pack[2] & 0xFF) + 5 != pack.length) {
            return null;
        }
        byte[] dats = new byte[pack.length - 5];
        for (int i = 0; i < dats.length; ++i) {
            dats[i] = pack[3 + i];
        }
        entity.setDat(dats);
        if (pack[dats.length + 3] != -2) {
            return null;
        }
        if (pack[dats.length + 4] != -2) {
            return null;
        }
        return entity;
    }

    public static byte[] encodePack(byte cmd) {
        byte[] dat = new byte[]{};
        return LRWProtocolFrame.encodePack(cmd, dat);
    }
}

