/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.iec104.slaver;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperateParam;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.utils.JsonUtils;
import cn.foxtech.device.protocol.v1.iec104.core.builder.ApduVOBuilder;
import cn.foxtech.device.protocol.v1.iec104.core.encoder.ValueEncoder;
import cn.foxtech.device.protocol.v1.iec104.core.entity.ApduEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.AsduEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.ControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.CotEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.IControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.VsqEntity;
import cn.foxtech.device.protocol.v1.iec104.core.enums.AsduTypeIdEnum;
import cn.foxtech.device.protocol.v1.iec104.core.enums.CotReasonEnum;
import cn.foxtech.device.protocol.v1.iec104.core.vo.ApduVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FoxEdgeDeviceType(value="IEC104 Device", manufacturer="Fox Edge")
public class IEC104SlaverSynchTime {
    @FoxEdgeOperate(name="\u65f6\u95f4\u540c\u6b65", polling=true, type="encoder", timeout=2000)
    @FoxEdgeOperateParam(names={"\u8bbe\u5907\u5730\u5740"}, values={"1"})
    public static Object encodeSessionRequest(Map<String, Object> param) {
        try {
            IControlEntity controlEntity = new IControlEntity();
            controlEntity.setSend((short)0);
            controlEntity.setAccept((short)0);
            ApduEntity apduEntity = new ApduEntity();
            apduEntity.setControl((ControlEntity)controlEntity);
            AsduEntity asduEntity = new AsduEntity();
            apduEntity.setAsdu(asduEntity);
            asduEntity.setTypeId(AsduTypeIdEnum.synchronizeDatetime.getValue());
            VsqEntity vsq = new VsqEntity();
            vsq.setSq(false);
            vsq.setNum(1);
            asduEntity.setVsq(vsq);
            CotEntity cot = new CotEntity();
            cot.setAddr(0);
            cot.setTest(false);
            cot.setPn(true);
            cot.setReason(CotReasonEnum.active.getValue());
            asduEntity.setCot(cot);
            asduEntity.setCommonAddress(1);
            Date date = new Date();
            byte[] cp56Time2a = ValueEncoder.encodeCP56Time2a((Date)date);
            HashMap<Integer, byte[]> body = new HashMap<Integer, byte[]>();
            body.put(0, cp56Time2a);
            byte[] data = ValueEncoder.encodeInfoBody(body);
            asduEntity.setData(data);
            ApduVO apduVO = ApduVOBuilder.buildVO((ApduEntity)apduEntity);
            return apduVO;
        }
        catch (Exception e) {
            throw new ProtocolException("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    @FoxEdgeOperate(name="\u65f6\u95f4\u540c\u6b65", polling=true, type="decoder", timeout=10000)
    @FoxEdgeOperateParam(names={"\u8bbe\u5907\u5730\u5740"}, values={"1"})
    public static Map<String, Object> decodeSessionRequest(Object respond, Map<String, Object> param) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        List apduMapList = (List)respond;
        for (Map apduMap : apduMapList) {
            ApduVO apduVO = (ApduVO)JsonUtils.buildObjectWithoutException((Map)apduMap, ApduVO.class);
            ApduEntity apduEntity = ApduVOBuilder.buildEntity((ApduVO)apduVO);
            AsduEntity asduEntity = apduEntity.getAsdu();
            if (asduEntity == null) continue;
            values.putAll(IEC104SlaverSynchTime.decodeSntp(asduEntity));
        }
        return values;
    }

    private static Map<String, Object> decodeSntp(AsduEntity asduEntity) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        VsqEntity vsq = asduEntity.getVsq();
        CotEntity cot = asduEntity.getCot();
        byte[] data = asduEntity.getData();
        if (CotReasonEnum.activeConfirmed.equals((Object)cot.getReason())) {
            if (data.length != 10) {
                throw new ProtocolException("\u8fd4\u56de\u7684\u5355\u70b9\u4fe1\u606f\u6570\u91cf\u4e0d\u6b63\u786e");
            }
            int address = data[0] & 0xFF;
            address += (data[1] & 0xFF) * 256;
            address += (data[2] & 0xFF) * 65536;
            Map bodys = ValueEncoder.decodeInfoBody((byte[])data, (int)7);
            if (bodys == null) {
                throw new ProtocolException("\u8fd4\u56de\u7684\u4fe1\u606f\u4f53\u4e0d\u6b63\u786e\uff01");
            }
            byte[] cp56Time2a = (byte[])bodys.get(0);
            if (cp56Time2a == null) {
                throw new ProtocolException("\u8fd4\u56de\u7684\u5730\u5740\u4e0d\u6b63\u786e\uff01");
            }
            Date date = ValueEncoder.decodeCP56Time2a((byte[])cp56Time2a);
            values.put("datetime", date.getTime());
        }
        return values;
    }
}

