/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.iec104.slaver;

import cn.foxtech.device.protocol.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperateParam;
import cn.foxtech.device.protocol.core.exception.ProtocolException;
import cn.foxtech.device.protocol.core.utils.BcdUtils;
import cn.foxtech.device.protocol.core.utils.JsonUtils;
import cn.foxtech.device.protocol.iec104.core.builder.ApduVOBuilder;
import cn.foxtech.device.protocol.iec104.core.entity.ApduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.AsduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.ControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.CotEntity;
import cn.foxtech.device.protocol.iec104.core.entity.IControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.VsqEntity;
import cn.foxtech.device.protocol.iec104.core.enums.AsduTypeIdEnum;
import cn.foxtech.device.protocol.iec104.core.enums.CotReasonEnum;
import cn.foxtech.device.protocol.iec104.core.vo.ApduVO;
import cn.foxtech.device.protocol.iec104.slaver.template.Iec104Template;
import cn.foxtech.device.protocol.iec104.slaver.template.JReadDataTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FoxEdgeDeviceType(value="IEC104 Device", manufacturer="Fox Edge")
public class IEC104SlaverGeneralCall {
    @FoxEdgeOperate(name="\u603b\u53ec\u5524", polling=true, type="encoder", timeout=10000)
    @FoxEdgeOperateParam(names={"\u8bbe\u5907\u5730\u5740"}, values={"1"})
    public static Object encodeSessionRequest(Map<String, Object> param) {
        try {
            IControlEntity controlEntity = new IControlEntity();
            controlEntity.setSend((short)0);
            controlEntity.setAccept((short)0);
            ApduEntity apduEntity = new ApduEntity();
            apduEntity.setControl((ControlEntity)controlEntity);
            AsduEntity asduEntity = new AsduEntity();
            apduEntity.setAsdu(asduEntity);
            asduEntity.setTypeId(AsduTypeIdEnum.generalCall.getValue());
            VsqEntity vsq = new VsqEntity();
            vsq.setSq(false);
            vsq.setNum(0);
            asduEntity.setVsq(vsq);
            CotEntity cot = new CotEntity();
            cot.setAddr(0);
            cot.setTest(false);
            cot.setPn(true);
            cot.setReason(CotReasonEnum.active.getValue());
            asduEntity.setCot(cot);
            asduEntity.setCommonAddress(1);
            byte[] data = new byte[]{0, 0, 0, 20};
            asduEntity.setData(data);
            ApduVO apduVO = ApduVOBuilder.buildVO((ApduEntity)apduEntity);
            apduVO.getWaitEndFlag().add(CotReasonEnum.activeEnded.getValue());
            return apduVO;
        }
        catch (Exception e) {
            throw new ProtocolException("\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    @FoxEdgeOperate(name="\u603b\u53ec\u5524", polling=true, type="decoder", timeout=10000)
    @FoxEdgeOperateParam(names={"\u8bbe\u5907\u5730\u5740"}, values={"1"})
    public static Map<String, Object> decodeSessionRequest(Object respond, Map<String, Object> param) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        String templateName = (String)param.get("template_name");
        String operateName = (String)param.get("operate_name");
        Map operate = (Map)param.get("operate");
        List decoderParams = (List)operate.get("decoder_param");
        HashMap<Integer, String> typeId2csv = new HashMap<Integer, String>();
        for (Map decoderParam : decoderParams) {
            typeId2csv.put(Integer.parseInt(decoderParam.get("typeId").toString()), decoderParam.get("table").toString());
        }
        List apduMapList = (List)respond;
        for (Map apduMap : apduMapList) {
            ApduVO apduVO = (ApduVO)JsonUtils.buildObjectWithoutException((Map)apduMap, ApduVO.class);
            ApduEntity apduEntity = ApduVOBuilder.buildEntity((ApduVO)apduVO);
            AsduEntity asduEntity = apduEntity.getAsdu();
            if (asduEntity == null) continue;
            values.putAll(IEC104SlaverGeneralCall.decodeSinglePointSignal(asduEntity, operateName, templateName, typeId2csv));
            values.putAll(IEC104SlaverGeneralCall.decodeScaledTelemetry(asduEntity, operateName, templateName, typeId2csv));
        }
        return values;
    }

    private static Map<String, Object> decodeSinglePointSignal(AsduEntity asduEntity, String operateName, String templateName, Map<Integer, String> typeId2csv) {
        Map<String, Object> values = new HashMap<String, Object>();
        if (AsduTypeIdEnum.singlePointSignal.getValue() != asduEntity.getTypeId()) {
            return values;
        }
        String csvFile = typeId2csv.get(AsduTypeIdEnum.singlePointSignal.getValue());
        JReadDataTemplate template = Iec104Template.newInstance().getTemplate(operateName, templateName, AsduTypeIdEnum.singlePointSignal.getValue(), csvFile, JReadDataTemplate.class);
        VsqEntity vsq = asduEntity.getVsq();
        CotEntity cot = asduEntity.getCot();
        byte[] data = asduEntity.getData();
        if (vsq.isSq() && CotReasonEnum.responseStationCall.getValue() == cot.getReason()) {
            if (vsq.getNum() + 3 != data.length) {
                throw new ProtocolException("\u8fd4\u56de\u7684\u5355\u70b9\u4fe1\u606f\u6570\u91cf\u4e0d\u6b63\u786e");
            }
            int address = data[0] & 0xFF;
            address += (data[1] & 0xFF) * 256;
            address += (data[2] & 0xFF) * 65536;
            int[] status = new int[vsq.getNum()];
            HashMap<Integer, Integer> statusList = new HashMap<Integer, Integer>();
            for (int i = 0; i < vsq.getNum(); ++i) {
                statusList.put(address + i, data[i + 3] & 0xFF);
            }
            values = template.decode(address, statusList);
        }
        return values;
    }

    private static Map<String, Object> decodeScaledTelemetry(AsduEntity asduEntity, String operateName, String templateName, Map<Integer, String> typeId2csv) {
        Map<String, Object> values = new HashMap<String, Object>();
        if (AsduTypeIdEnum.scaledTelemetry.getValue() != asduEntity.getTypeId()) {
            return values;
        }
        String csvFile = typeId2csv.get(AsduTypeIdEnum.scaledTelemetry.getValue());
        JReadDataTemplate template = Iec104Template.newInstance().getTemplate(operateName, templateName, AsduTypeIdEnum.scaledTelemetry.getValue(), csvFile, JReadDataTemplate.class);
        VsqEntity vsq = asduEntity.getVsq();
        CotEntity cot = asduEntity.getCot();
        byte[] data = asduEntity.getData();
        if (vsq.isSq() && CotReasonEnum.responseStationCall.getValue() == cot.getReason()) {
            if (vsq.getNum() * 3 + 3 != data.length) {
                throw new ProtocolException("\u8fd4\u56de\u7684\u6d4b\u91cf\u503c\u6807\u5ea6\u5316\u503c\u4fe1\u606f\u6570\u91cf\u4e0d\u6b63\u786e");
            }
            int address = data[0] & 0xFF;
            address += (data[1] & 0xFF) * 256;
            address += (data[2] & 0xFF) * 65536;
            HashMap<Integer, Integer> statusList = new HashMap<Integer, Integer>();
            for (int i = 0; i < vsq.getNum(); ++i) {
                int v0 = BcdUtils.bcd2int((byte)data[3 * i + 3]);
                int v1 = BcdUtils.bcd2int((byte)data[3 * i + 4]);
                int v2 = BcdUtils.bcd2int((byte)data[3 * i + 5]);
                statusList.put(address + i, v0 + v1 * 10 + v2 * 100);
            }
            values = template.decode(address, statusList);
        }
        return values;
    }
}

