/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.iec104.core.enums;

import cn.foxtech.device.protocol.v1.iec104.core.enums.AsduTypeIdEnum;

public enum QualifiersEnum {
    generalCallQualifiers(AsduTypeIdEnum.generalCall, 32),
    generalCallGroupingQualifiers(AsduTypeIdEnum.generalCall, 20),
    resetPprocessQualifiers(AsduTypeIdEnum.resetPprocess, 1),
    localCloseUpQualifiers(AsduTypeIdEnum.initEnd, 0),
    localMmanualResetQualifiers(AsduTypeIdEnum.initEnd, 1),
    distanceResetQualifiers(AsduTypeIdEnum.initEnd, 2),
    qualityQualifiers(null, 0),
    prefabParameterQualifiers(null, 64),
    activationParameterQualifiers(null, 15);

    private final byte value;
    private final AsduTypeIdEnum typeIdentifier;

    private QualifiersEnum(AsduTypeIdEnum typeIdentifier, int value) {
        this.value = (byte)value;
        this.typeIdentifier = typeIdentifier;
    }

    public static QualifiersEnum getQualifiersEnum(AsduTypeIdEnum typeIdentifier, byte value) {
        for (QualifiersEnum type : QualifiersEnum.values()) {
            if (type.getValue() != value || type.getTypeIdentifier() != typeIdentifier) continue;
            return type;
        }
        QualifiersEnum qualifiersEnum = null;
        if ((AsduTypeIdEnum.normalizedTelemetry.equals((Object)typeIdentifier) || AsduTypeIdEnum.scaledTelemetry.equals((Object)typeIdentifier) || AsduTypeIdEnum.shortFloatingPointTelemetry.equals((Object)typeIdentifier)) && qualityQualifiers.getValue() == value) {
            qualifiersEnum = qualityQualifiers;
        }
        if ((AsduTypeIdEnum.readOneParameter.equals((Object)typeIdentifier) || AsduTypeIdEnum.readMultipleParameter.equals((Object)typeIdentifier) || AsduTypeIdEnum.prefabActivationOneParameter.equals((Object)typeIdentifier) || AsduTypeIdEnum.prefabActivationMultipleParameter.equals((Object)typeIdentifier)) && qualityQualifiers.getValue() == value) {
            qualifiersEnum = qualityQualifiers;
        }
        return qualifiersEnum;
    }

    public byte getValue() {
        return this.value;
    }

    public AsduTypeIdEnum getTypeIdentifier() {
        return this.typeIdentifier;
    }
}

