/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.iec104.core.encoder;

import cn.foxtech.device.protocol.v1.iec104.core.encoder.ValueEncoder;
import cn.foxtech.device.protocol.v1.iec104.core.entity.ControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.IControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.SControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.entity.UControlEntity;
import cn.foxtech.device.protocol.v1.iec104.core.enums.FrameTypeEnum;
import cn.foxtech.device.protocol.v1.iec104.core.enums.UControlTypeEnum;

public class ControlEncoder {
    public static byte[] encodeControl(ControlEntity entity) {
        if (entity instanceof IControlEntity) {
            return ControlEncoder.encodeControl((IControlEntity)entity);
        }
        if (entity instanceof SControlEntity) {
            return ControlEncoder.encodeControl((SControlEntity)entity);
        }
        if (entity instanceof UControlEntity) {
            return ControlEncoder.encodeControl((UControlEntity)entity);
        }
        return new byte[4];
    }

    public static byte[] encodeControl(IControlEntity entity) {
        byte[] control = new byte[4];
        short send = entity.getSend();
        send = (short)(send << 1);
        control[0] = (byte)send;
        control[1] = (byte)(send >> 8);
        short accept = entity.getAccept();
        accept = (short)(accept << 1);
        control[2] = (byte)accept;
        control[3] = (byte)(accept >> 8);
        return control;
    }

    public static byte[] encodeControl(SControlEntity entity) {
        byte[] control = new byte[4];
        int send = 1;
        control[0] = (byte)send;
        control[1] = (byte)(send >> 8);
        short accept = entity.getAccept();
        accept = (short)(accept << 1);
        control[2] = (byte)accept;
        control[3] = (byte)(accept >> 8);
        return control;
    }

    public static byte[] encodeControl(UControlEntity entity) {
        UControlTypeEnum value = entity.getValue();
        if (value != null) {
            return ValueEncoder.intToByteArray(value.getValue());
        }
        return new byte[4];
    }

    public static void decodeControl(byte[] control, IControlEntity entity) {
        short send = ControlEncoder.decodeSend(control);
        short accept = ControlEncoder.decodeAccept(control);
        entity.setSend(send);
        entity.setAccept(accept);
    }

    public static void decodeControl(byte[] control, SControlEntity entity) {
        short accept = ControlEncoder.decodeAccept(control);
        entity.setAccept(accept);
    }

    public static void decodeControl(byte[] control, UControlEntity entity) {
        UControlTypeEnum value = ControlEncoder.decodeUControl(control);
        entity.setValue(value);
    }

    public static ControlEntity decodeEntity(byte[] control, FrameTypeEnum formatType) {
        if (FrameTypeEnum.I_FORMAT.equals((Object)formatType)) {
            IControlEntity entity = new IControlEntity();
            ControlEncoder.decodeControl(control, entity);
            return entity;
        }
        if (FrameTypeEnum.S_FORMAT.equals((Object)formatType)) {
            SControlEntity entity = new SControlEntity();
            ControlEncoder.decodeControl(control, entity);
            return entity;
        }
        if (FrameTypeEnum.U_FORMAT.equals((Object)formatType)) {
            UControlEntity entity = new UControlEntity();
            ControlEncoder.decodeControl(control, entity);
            return entity;
        }
        return null;
    }

    private static short decodeAccept(byte[] control) {
        int accept = 0;
        short acceptLow = (short)(control[2] & 0xFF);
        short acceptHigh = (short)(control[3] & 0xFF);
        accept += acceptLow;
        accept += acceptHigh << 8;
        return (short)(accept >>= 1);
    }

    private static short decodeSend(byte[] control) {
        int send = 0;
        short acceptLow = (short)(control[0] & 0xFF);
        short acceptHigh = (short)(control[1] & 0xFF);
        send += acceptLow;
        send += acceptHigh << 8;
        return (short)(send >>= 1);
    }

    private static UControlTypeEnum decodeUControl(byte[] control) {
        if (control.length < 4 || control[1] != 0 || control[3] != 0 || control[2] != 0) {
            return null;
        }
        int controlInt = ValueEncoder.byteArrayToInt(control);
        for (UControlTypeEnum ucontrolEnum : UControlTypeEnum.values()) {
            if (ucontrolEnum.getValue() != controlInt) continue;
            return ucontrolEnum;
        }
        return null;
    }
}

