/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.iec104.core.encoder;

import java.io.ByteArrayOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueEncoder {
    public static byte[] encodeInfoBody(int address, List<byte[]> bodys) {
        int sumLen = 0;
        for (byte[] body : bodys) {
            sumLen += body.length;
        }
        byte[] data = new byte[3 + sumLen];
        data[0] = (byte)(address & 0xFF);
        data[1] = (byte)((address & 0xFF00) >> 8);
        data[2] = 0;
        int offset = 3;
        for (byte[] body : bodys) {
            System.arraycopy(body, 0, data, offset, data.length);
            offset += body.length;
        }
        return data;
    }

    public static byte[] encodeInfoBody(Map<Integer, byte[]> bodys) {
        int sumLen = 0;
        for (Map.Entry<Integer, byte[]> entry : bodys.entrySet()) {
            sumLen += 3;
            sumLen += entry.getValue().length;
        }
        byte[] data = new byte[3 + sumLen];
        int offset = 0;
        for (Map.Entry<Integer, byte[]> entry : bodys.entrySet()) {
            int address = entry.getKey();
            byte[] body = entry.getValue();
            data[offset + 0] = (byte)(address & 0xFF);
            data[offset + 1] = (byte)((address & 0xFF00) >> 8);
            data[offset + 2] = 0;
            System.arraycopy(body, 0, data, offset += 3, body.length);
            offset += body.length;
        }
        return data;
    }

    public static Map<Integer, byte[]> decodeInfoBody(byte[] data, int infoSize) {
        HashMap<Integer, byte[]> bodys = new HashMap<Integer, byte[]>();
        if ((data.length - 3) % infoSize != 0) {
            return null;
        }
        int address = data[0] & 0xFF;
        address += (data[1] & 0xFF) * 256;
        if (data[2] != 0) {
            return null;
        }
        int num = (data.length - 3) / infoSize;
        for (int i = 0; i < num; ++i) {
            byte[] info = new byte[infoSize];
            System.arraycopy(data, i * infoSize + 3, info, 0, info.length);
            bodys.put(address + i, info);
        }
        return bodys;
    }

    public static byte[] encodeCP56Time2a(Date date) {
        ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int millisecond = calendar.get(13) * 1000 + calendar.get(14);
        byte[] millisecondByte = ValueEncoder.intToByteArray(millisecond);
        bOutput.write(millisecondByte[3]);
        bOutput.write(millisecondByte[2]);
        bOutput.write((byte)calendar.get(12));
        bOutput.write((byte)calendar.get(11));
        int week = calendar.get(7);
        week = week == 1 ? 7 : --week;
        bOutput.write((byte)(week << 5) + calendar.get(5));
        bOutput.write((byte)((byte)calendar.get(2) + 1));
        bOutput.write((byte)(calendar.get(1) - 2000));
        return bOutput.toByteArray();
    }

    public static Date decodeCP56Time2a(byte[] dataByte) {
        int year = (dataByte[6] & 0x7F) + 2000;
        int month = dataByte[5] & 0xF;
        int day = dataByte[4] & 0x1F;
        int hour = dataByte[3] & 0x1F;
        int minute = dataByte[2] & 0x3F;
        int second = dataByte[1] > 0 ? dataByte[1] : dataByte[1] & 0xFF;
        int millisecond = dataByte[0] > 0 ? dataByte[0] : dataByte[0] & 0xFF;
        millisecond = (second << 8) + millisecond;
        second = millisecond / 1000;
        millisecond %= 1000;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static byte[] intToByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] shortToByteArray(short val) {
        byte[] b = new byte[]{(byte)(val >> 8 & 0xFF), (byte)(val & 0xFF)};
        return b;
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static short byteArrayToShort(byte[] bytes) {
        short value = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            value = (short)(value + ((bytes[i] & 0xFF) << shift));
        }
        return value;
    }

    public static String byteArrayToHexString(byte[] array) {
        return ValueEncoder.byteArray2HexString(array, Integer.MAX_VALUE, false);
    }

    public static String byteArray2HexString(byte[] arrBytes, int count, boolean blank) {
        String ret = "";
        if (arrBytes == null || arrBytes.length < 1) {
            return ret;
        }
        if (count > arrBytes.length) {
            count = arrBytes.length;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            ret = Integer.toHexString(arrBytes[i] & 0xFF).toUpperCase();
            if (ret.length() == 1) {
                builder.append("0").append(ret);
            } else {
                builder.append(ret);
            }
            if (!blank) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public static byte[] getByte(byte[] bytes, int start, int length) {
        byte[] ruleByte = new byte[length];
        int index = 0;
        while (index < length) {
            ruleByte[index++] = bytes[start++];
        }
        return ruleByte;
    }

    public static byte[] hexStringToBytes(String hexStr) {
        hexStr = hexStr.replaceAll(" ", "");
        hexStr = hexStr.toUpperCase();
        int len = hexStr.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hexStr.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(ValueEncoder.toByte(achar[pos]) << 4 | ValueEncoder.toByte(achar[pos + 1]));
        }
        return result;
    }

    private static int toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }
}

