/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.iec104.core.encoder;

import cn.foxtech.device.protocol.iec104.core.encoder.ApduEncoder;
import cn.foxtech.device.protocol.iec104.core.entity.ApduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.AsduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.CotEntity;
import cn.foxtech.device.protocol.iec104.core.entity.IControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.SControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.UControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.VsqEntity;
import cn.foxtech.device.protocol.iec104.core.enums.AsduTypeIdEnum;
import cn.foxtech.device.protocol.iec104.core.enums.CotReasonEnum;
import cn.foxtech.device.protocol.iec104.core.enums.UControlTypeEnum;

public class BasicSessionEncoder {
    public static byte[] encodeSFrameRespond(short accept) throws Exception {
        SControlEntity controlEntity = new SControlEntity();
        controlEntity.setAccept(accept);
        ApduEntity apduEntity = new ApduEntity();
        apduEntity.setControl(controlEntity);
        apduEntity.setAsdu(null);
        return ApduEncoder.encodeApdu(apduEntity);
    }

    public static byte[] encodeSTARTDTByRequest() throws Exception {
        UControlEntity controlEntity = new UControlEntity();
        controlEntity.setValue(UControlTypeEnum.STARTDT);
        ApduEntity apduEntity = new ApduEntity();
        apduEntity.setControl(controlEntity);
        apduEntity.setAsdu(null);
        return ApduEncoder.encodeApdu(apduEntity);
    }

    public static ApduEntity decodeSTARTDTByRespond(byte[] pdu) throws Exception {
        return ApduEncoder.decodeApdu(pdu);
    }

    public static byte[] encodeTESTFRByRequest() throws Exception {
        UControlEntity controlEntity = new UControlEntity();
        controlEntity.setValue(UControlTypeEnum.TESTFR);
        ApduEntity apduEntity = new ApduEntity();
        apduEntity.setControl(controlEntity);
        apduEntity.setAsdu(null);
        return ApduEncoder.encodeApdu(apduEntity);
    }

    public static ApduEntity decodeTESTFRByRespond(byte[] pdu) throws Exception {
        return ApduEncoder.decodeApdu(pdu);
    }

    public static ApduEntity encodeGeneralCallAsduByRequest(short send) throws Exception {
        IControlEntity controlEntity = new IControlEntity();
        controlEntity.setSend(send);
        controlEntity.setAccept((short)0);
        ApduEntity apduEntity = new ApduEntity();
        apduEntity.setControl(controlEntity);
        AsduEntity asduEntity = new AsduEntity();
        apduEntity.setAsdu(asduEntity);
        asduEntity.setTypeId(AsduTypeIdEnum.generalCall.getValue());
        VsqEntity vsq = new VsqEntity();
        vsq.setSq(false);
        vsq.setNum(0);
        asduEntity.setVsq(vsq);
        CotEntity cot = new CotEntity();
        cot.setAddr(0);
        cot.setTest(false);
        cot.setPn(true);
        cot.setReason(CotReasonEnum.active.getValue());
        asduEntity.setCot(cot);
        asduEntity.setCommonAddress(1);
        byte[] data = new byte[]{20};
        asduEntity.setData(data);
        return apduEntity;
    }

    public static byte[] encodeGeneralCallByRequest(short send) throws Exception {
        return ApduEncoder.encodeApdu(BasicSessionEncoder.encodeGeneralCallAsduByRequest(send));
    }

    public static ApduEntity decodeGeneralCallByRespond(byte[] pdu) throws Exception {
        ApduEntity apduEntity = ApduEncoder.decodeApdu(pdu);
        return apduEntity;
    }

    public static ApduEntity encodePowerPulseCallAsduByRequest(short send) throws Exception {
        IControlEntity controlEntity = new IControlEntity();
        controlEntity.setSend(send);
        controlEntity.setAccept((short)0);
        ApduEntity apduEntity = new ApduEntity();
        apduEntity.setControl(controlEntity);
        AsduEntity asduEntity = new AsduEntity();
        apduEntity.setAsdu(asduEntity);
        asduEntity.setTypeId(AsduTypeIdEnum.powerPulseCall.getValue());
        VsqEntity vsq = new VsqEntity();
        vsq.setSq(false);
        vsq.setNum(1);
        asduEntity.setVsq(vsq);
        CotEntity cot = new CotEntity();
        cot.setAddr(0);
        cot.setTest(false);
        cot.setPn(true);
        cot.setReason(CotReasonEnum.active.getValue());
        asduEntity.setCot(cot);
        asduEntity.setCommonAddress(1);
        byte[] data = new byte[]{0, 0, 0, 69};
        asduEntity.setData(data);
        return apduEntity;
    }
}

