/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.iec104.core.encoder;

import cn.foxtech.device.protocol.iec104.core.encoder.ControlEncoder;
import cn.foxtech.device.protocol.iec104.core.encoder.CotEncoder;
import cn.foxtech.device.protocol.iec104.core.encoder.VsqEncoder;
import cn.foxtech.device.protocol.iec104.core.entity.ApduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.AsduEntity;
import cn.foxtech.device.protocol.iec104.core.entity.ControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.CotEntity;
import cn.foxtech.device.protocol.iec104.core.entity.IControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.SControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.UControlEntity;
import cn.foxtech.device.protocol.iec104.core.entity.VsqEntity;
import cn.foxtech.device.protocol.iec104.core.enums.FrameTypeEnum;
import cn.foxtech.device.protocol.iec104.core.enums.UControlTypeEnum;
import java.util.Set;

public class ApduEncoder {
    public static byte[] encodeApdu(ApduEntity apdu) throws Exception {
        int length = 0;
        if (apdu.getControl() != null && apdu.getAsdu() == null) {
            length = 6;
        } else if (apdu.getControl() != null && apdu.getAsdu() != null) {
            length = 12 + apdu.getAsdu().getData().length;
        } else {
            throw new Exception("APCI\u4e0d\u80fd\u4e3anull");
        }
        byte[] pdu = new byte[length];
        pdu[0] = 104;
        pdu[1] = (byte)(length - 2);
        byte[] control = ControlEncoder.encodeControl(apdu.getControl());
        pdu[2] = control[0];
        pdu[3] = control[1];
        pdu[4] = control[2];
        pdu[5] = control[3];
        if (apdu.getAsdu() == null) {
            return pdu;
        }
        AsduEntity asdu = apdu.getAsdu();
        pdu[6] = (byte)asdu.getTypeId();
        pdu[7] = (byte)VsqEncoder.encodeVsq(asdu.getVsq());
        int cot = CotEncoder.encodeCot(asdu.getCot());
        pdu[8] = (byte)(cot & 0xFF);
        pdu[9] = (byte)((cot & 0xFF00) >> 8);
        pdu[10] = (byte)(asdu.getCommonAddress() & 0xFF);
        pdu[11] = (byte)((asdu.getCommonAddress() & 0xFF00) >> 8);
        System.arraycopy(asdu.getData(), 0, pdu, 12, asdu.getData().length);
        return pdu;
    }

    public static ApduEntity decodeApdu(byte[] pdu) throws Exception {
        ControlEntity controlEntity;
        if (pdu.length < 6) {
            throw new Exception("\u5e27\u957f\u5ea6\u5c0f\u4e8e6");
        }
        if ((pdu[0] & 0xFF) != 104) {
            throw new Exception("\u542f\u52a8\u5b57\u7b26\u5fc5\u987b\u4e3a0x68");
        }
        if ((pdu[0] & 0xFF) != 104) {
            throw new Exception("\u542f\u52a8\u5b57\u7b26\u5fc5\u987b\u4e3a0x68");
        }
        if (pdu.length != (pdu[1] & 0xFF) + 2) {
            throw new Exception("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        byte[] control = new byte[]{pdu[2], pdu[3], pdu[4], pdu[5]};
        FrameTypeEnum formatType = ApduEncoder.identifyFormatType(pdu);
        if (FrameTypeEnum.ERR_FORMAT.equals((Object)formatType)) {
            throw new Exception("\u62a5\u6587\u683c\u5f0f\u975e\u6cd5\uff01");
        }
        ApduEntity apdu = new ApduEntity();
        if (FrameTypeEnum.I_FORMAT.equals((Object)formatType)) {
            if (pdu.length <= 6) {
                throw new Exception("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            controlEntity = new IControlEntity();
            ControlEncoder.decodeControl(control, controlEntity);
            apdu.setControl(controlEntity);
            apdu.setAsdu(new AsduEntity());
        }
        if (FrameTypeEnum.S_FORMAT.equals((Object)formatType)) {
            if (pdu.length != 6) {
                throw new Exception("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            controlEntity = new SControlEntity();
            ControlEncoder.decodeControl(control, (SControlEntity)controlEntity);
            apdu.setControl(controlEntity);
            apdu.setAsdu(null);
        }
        if (FrameTypeEnum.U_FORMAT.equals((Object)formatType)) {
            if (pdu.length != 6) {
                throw new Exception("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            controlEntity = new UControlEntity();
            ControlEncoder.decodeControl(control, (UControlEntity)controlEntity);
            apdu.setControl(controlEntity);
            apdu.setAsdu(null);
        }
        if (!FrameTypeEnum.I_FORMAT.equals((Object)formatType)) {
            return apdu;
        }
        AsduEntity asdu = apdu.getAsdu();
        asdu.setTypeId(pdu[6] & 0xFF);
        VsqEntity vsq = VsqEncoder.decodeVsq(pdu[7] & 0xFF);
        asdu.setVsq(vsq);
        CotEntity cot = CotEncoder.decodeCot((pdu[8] & 0xFF) + ((pdu[9] & 0xFF) << 8));
        asdu.setCot(cot);
        asdu.setCommonAddress((pdu[10] & 0xFF) + ((pdu[11] & 0xFF) << 8));
        asdu.setData(new byte[(pdu[1] & 0xFF) - 10]);
        System.arraycopy(pdu, 12, asdu.getData(), 0, asdu.getData().length);
        return apdu;
    }

    public static FrameTypeEnum identifyFormatType(byte[] pdu) {
        if (pdu.length < 6) {
            return FrameTypeEnum.ERR_FORMAT;
        }
        if (pdu.length != (pdu[1] & 0xFF) + 2) {
            return FrameTypeEnum.ERR_FORMAT;
        }
        if (pdu.length > 6) {
            if ((pdu[2] & 1) == 0 && (pdu[4] & 1) == 0) {
                return FrameTypeEnum.I_FORMAT;
            }
            return FrameTypeEnum.ERR_FORMAT;
        }
        if (pdu.length == 6) {
            boolean sformat;
            boolean bl = sformat = pdu[2] == 1 && pdu[3] == 0 && (pdu[4] & 1) == 0;
            if (sformat) {
                return FrameTypeEnum.S_FORMAT;
            }
            boolean uformat = true;
            Set<Integer> cmds = UControlTypeEnum.getTypes();
            if (!cmds.contains(pdu[2] & 0xFF)) {
                uformat = false;
            }
            if (pdu[3] != 0) {
                uformat = false;
            }
            if (pdu[4] != 0) {
                uformat = false;
            }
            if (pdu[5] != 0) {
                uformat = false;
            }
            if (uformat) {
                return FrameTypeEnum.U_FORMAT;
            }
            return FrameTypeEnum.ERR_FORMAT;
        }
        return FrameTypeEnum.ERR_FORMAT;
    }
}

