/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.hikvision.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.hikvision.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.hikvision.fire.core.utils.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class InfObjDeviceOperateEntity
extends InfObjEntity {
    private boolean reset = false;
    private boolean mute = false;
    private boolean manualAlarm = false;
    private boolean clearAlarm = false;
    private boolean selfCheck = false;
    private boolean reserve1 = false;
    private boolean test = false;
    private boolean reserve2 = false;
    private int operator = 0;
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjDeviceOperateEntity entity) {
        int sysStatus;
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.reset = ((sysStatus = data[index++] & 0xFF) & 1) != 0;
        entity.mute = (sysStatus & 2) != 0;
        entity.manualAlarm = (sysStatus & 4) != 0;
        entity.clearAlarm = (sysStatus & 8) != 0;
        entity.selfCheck = (sysStatus & 0x10) != 0;
        entity.reserve1 = (sysStatus & 0x20) != 0;
        entity.test = (sysStatus & 0x40) != 0;
        entity.reserve2 = (sysStatus & 0x80) != 0;
        entity.operator = data[index++] & 0xFF;
        entity.time = TimeUtil.decodeTime6byte(data, index);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjDeviceOperateEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        int sysStatus = 0;
        sysStatus |= entity.reset ? 1 : 0;
        sysStatus |= entity.mute ? 2 : 0;
        sysStatus |= entity.manualAlarm ? 4 : 0;
        sysStatus |= entity.clearAlarm ? 8 : 0;
        sysStatus |= entity.selfCheck ? 16 : 0;
        sysStatus |= entity.reserve1 ? 32 : 0;
        sysStatus |= entity.test ? 64 : 0;
        data[index++] = (byte)(sysStatus |= entity.reserve2 ? 128 : 0);
        data[index++] = (byte)entity.operator;
        TimeUtil.encodeTime6byte(entity.time, data, index);
        index += 6;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    public int size() {
        return 8;
    }

    @Override
    public void decode(byte[] data) {
        InfObjDeviceOperateEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjDeviceOperateEntity.encodeEntity(this);
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isMute() {
        return this.mute;
    }

    public boolean isManualAlarm() {
        return this.manualAlarm;
    }

    public boolean isClearAlarm() {
        return this.clearAlarm;
    }

    public boolean isSelfCheck() {
        return this.selfCheck;
    }

    public boolean isReserve1() {
        return this.reserve1;
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isReserve2() {
        return this.reserve2;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getTime() {
        return this.time;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
    }

    public void setManualAlarm(boolean manualAlarm) {
        this.manualAlarm = manualAlarm;
    }

    public void setClearAlarm(boolean clearAlarm) {
        this.clearAlarm = clearAlarm;
    }

    public void setSelfCheck(boolean selfCheck) {
        this.selfCheck = selfCheck;
    }

    public void setReserve1(boolean reserve1) {
        this.reserve1 = reserve1;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setReserve2(boolean reserve2) {
        this.reserve2 = reserve2;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

