/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.hikvision.fire.core.utils;

public class AddressUtil {
    public static final String PLATFORM_DEFAULT = "FFFFFFFFFFFF";
    public static final String DEVICE_DEFAULT = "000000000000";

    public static String decodeAddress6byte(byte[] data, int offset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            byte dat = data[offset + i];
            sb.append(AddressUtil.getChar((byte)((dat & 0xF0) >> 4)));
            sb.append(AddressUtil.getChar((byte)(dat & 0xF)));
        }
        return sb.toString();
    }

    public static void encodeAddress6byte(String address, byte[] data, int offset) {
        int i;
        int length = 6;
        if (address.length() / 2 < length) {
            for (i = 0; i < length - address.length() / 2; ++i) {
                data[i + offset] = 0;
            }
        }
        while (i < length) {
            int h = AddressUtil.getInt(address.charAt(2 * i + 0));
            int l = AddressUtil.getInt(address.charAt(2 * i + 1));
            data[i + offset] = (byte)(h * 16 + l);
            ++i;
        }
    }

    private static char getChar(byte c) {
        if (0 <= c && c <= 9) {
            return (char)(c + 48);
        }
        if (10 <= c && c <= 15) {
            return (char)(c - 10 + 65);
        }
        return '0';
    }

    private static int getInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }
}

