/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.hikvision.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.hikvision.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.hikvision.fire.core.utils.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class InfObjDeviceStatusEntity
extends InfObjEntity {
    private boolean normal = false;
    private boolean fireAlarm = false;
    private boolean fault = false;
    private boolean mainFault = false;
    private boolean backFault = false;
    private boolean commFault = false;
    private boolean linkFault = false;
    private boolean reserve = false;
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjDeviceStatusEntity entity) {
        int sysStatus;
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.normal = ((sysStatus = data[index++] & 0xFF) & 1) != 0;
        entity.fireAlarm = (sysStatus & 2) != 0;
        entity.fault = (sysStatus & 4) != 0;
        entity.mainFault = (sysStatus & 8) != 0;
        entity.backFault = (sysStatus & 0x10) != 0;
        entity.commFault = (sysStatus & 0x20) != 0;
        entity.linkFault = (sysStatus & 0x40) != 0;
        entity.reserve = (sysStatus & 0x80) != 0;
        entity.time = TimeUtil.decodeTime6byte(data, index);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjDeviceStatusEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        int sysStatus = 0;
        sysStatus |= entity.normal ? 1 : 0;
        sysStatus |= entity.fireAlarm ? 2 : 0;
        sysStatus |= entity.fault ? 4 : 0;
        sysStatus |= entity.mainFault ? 8 : 0;
        sysStatus |= entity.backFault ? 16 : 0;
        sysStatus |= entity.commFault ? 32 : 0;
        sysStatus |= entity.linkFault ? 64 : 0;
        data[index++] = (byte)(sysStatus |= entity.reserve ? 128 : 0);
        TimeUtil.encodeTime6byte(entity.time, data, index);
        index += 6;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    public int size() {
        return 7;
    }

    @Override
    public void decode(byte[] data) {
        InfObjDeviceStatusEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjDeviceStatusEntity.encodeEntity(this);
    }

    public boolean isNormal() {
        return this.normal;
    }

    public boolean isFireAlarm() {
        return this.fireAlarm;
    }

    public boolean isFault() {
        return this.fault;
    }

    public boolean isMainFault() {
        return this.mainFault;
    }

    public boolean isBackFault() {
        return this.backFault;
    }

    public boolean isCommFault() {
        return this.commFault;
    }

    public boolean isLinkFault() {
        return this.linkFault;
    }

    public boolean isReserve() {
        return this.reserve;
    }

    public String getTime() {
        return this.time;
    }

    public void setNormal(boolean normal) {
        this.normal = normal;
    }

    public void setFireAlarm(boolean fireAlarm) {
        this.fireAlarm = fireAlarm;
    }

    public void setFault(boolean fault) {
        this.fault = fault;
    }

    public void setMainFault(boolean mainFault) {
        this.mainFault = mainFault;
    }

    public void setBackFault(boolean backFault) {
        this.backFault = backFault;
    }

    public void setCommFault(boolean commFault) {
        this.commFault = commFault;
    }

    public void setLinkFault(boolean linkFault) {
        this.linkFault = linkFault;
    }

    public void setReserve(boolean reserve) {
        this.reserve = reserve;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

