/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haiwu.air.v200;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.haiwu.air.v200.uitls.ValueUtils;
import cn.foxtech.device.protocol.v1.telecom.core.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u57fa\u7ad9\u7a7a\u8c03(V2.00)", manufacturer="\u5e7f\u4e1c\u6d77\u609f\u79d1\u6280\u6709\u9650\u516c\u53f8")
public class GetAnalog {
    @FoxEdgeOperate(name="\u83b7\u53d6\u6a21\u62df\u91cf\uff08\u5b9a\u70b9\u6570\uff09", polling=true, type="encoder", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:devAddr");
        }
        PduEntity pduEntity = new PduEntity();
        pduEntity.setAddr(devAddr.intValue());
        pduEntity.setVer(16);
        pduEntity.setCid1(96);
        pduEntity.setCid2(66);
        byte[] pdu = PduEntity.encodePdu((PduEntity)pduEntity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u83b7\u53d6\u6a21\u62df\u91cf\uff08\u5b9a\u70b9\u6570\uff09", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu((byte[])pdu);
        if (entity.getCid1() != 96) {
            throw new ProtocolException("\u8fd4\u56de\u7684CID1\u4e0d\u6b63\u786e!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("rtn", entity.getCid2());
        byte[] data = entity.getData();
        if (data.length != 37) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        int index = 0;
        int value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a\u7535\u6e90\u76f8\u7535\u538bA", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a\u7535\u6e90\u76f8\u7535\u538bB", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a\u7535\u6e90\u76f8\u7535\u538bC", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a/\u538b\u7f29\u673a\u5de5\u4f5c\u7535\u6d41A\u76f8", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a/\u538b\u7f29\u673a\u5de5\u4f5c\u7535\u6d41B\u76f8", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u4e3b\u673a/\u538b\u7f29\u673a\u5de5\u4f5c\u7535\u6d41C\u76f8", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u9001\u98ce\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e29\u5ea6/\u5ba4\u5185\u73af\u5883\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u9001\u98ce\u6e7f\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e7f\u5ea6/\u5ba4\u5185\u73af\u5883\u6e7f\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u538b\u7f29\u673a\u5438\u6c14\u538b\u529b", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u538b\u7f29\u673a\u6392\u6c14\u538b\u529b", value);
        }
        result.put("\u7528\u6237\u81ea\u5b9a\u4e49\u9065\u6d4b\u6570\u91cf", data[index]);
        value = ValueUtils.decodeInteger(data, ++index);
        index += 2;
        if (value != 8224 && value != 0) {
            result.put("\u5ba4\u5916\u73af\u5883\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u538b\u7f29\u673a\u6392\u6c14\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5ba4\u5916\u6e7f\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5ba4\u5185\u76d8\u7ba1/\u84b8\u53d1\u5668\u76d8\u7ba1\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u538b\u7f29\u673a\u8fd0\u884c\u65f6\u95f4", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u673a\u7ec4\u8fd0\u884c\u65f6\u95f4", value);
        }
        return result;
    }
}

