/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haiwu.air.v10d;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.haiwu.air.v10d.enums.Type;
import cn.foxtech.device.protocol.v1.haiwu.air.v10d.uitls.TypeValueUtils;
import cn.foxtech.device.protocol.v1.haiwu.air.v10d.uitls.ValueUtils;
import cn.foxtech.device.protocol.v1.telecom.core.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u57fa\u7ad9\u7a7a\u8c03(V1.0D)", manufacturer="\u5e7f\u4e1c\u6d77\u609f\u79d1\u6280\u6709\u9650\u516c\u53f8")
public class GetParam {
    @FoxEdgeOperate(name="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff08\u5b9a\u70b9\u6570\uff09", polling=true, type="encoder", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:devAddr");
        }
        PduEntity pduEntity = new PduEntity();
        pduEntity.setAddr(devAddr.intValue());
        pduEntity.setVer(16);
        pduEntity.setCid1(96);
        pduEntity.setCid2(71);
        byte[] pdu = PduEntity.encodePdu((PduEntity)pduEntity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\uff08\u5b9a\u70b9\u6570\uff09", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu((byte[])pdu);
        if (entity.getCid1() != 96) {
            throw new ProtocolException("\u8fd4\u56de\u7684CID1\u4e0d\u6b63\u786e!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("rtn", entity.getCid2());
        byte[] data = entity.getData();
        if (data.length != 33) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        int index = 0;
        int value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u7a7a\u8c03\u5f00\u673a\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u7a7a\u8c03\u5173\u673a\u6e29\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e29\u5ea6\u4e0a\u9650", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e29\u5ea6\u4e0b\u9650", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e7f\u5ea6\u4e0a\u9650", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u56de\u98ce\u6e7f\u5ea6\u4e0b\u9650", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5236\u51b7\u6a21\u5f0f\u6e29\u5ea6\u8bbe\u5b9a\u503c", value);
        }
        result.put("\u7528\u6237\u81ea\u5b9a\u4e49\u9065\u6d4b\u6570\u91cf", data[index]);
        value = ValueUtils.decodeInteger(data, ++index);
        index += 2;
        if (value != 8224) {
            result.put("\u8fd0\u884c\u6a21\u5f0f\u8bbe\u5b9a", value);
            result.put("\u8fd0\u884c\u6a21\u5f0f\u8bbe\u5b9a-TEXT", TypeValueUtils.getTypeValueText(Type.EC0, value));
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5185\u98ce\u673a\u98ce\u901f\u8bbe\u5b9a", value);
            result.put("\u5185\u98ce\u673a\u98ce\u901f\u8bbe\u5b9a-TEXT", TypeValueUtils.getTypeValueText(Type.EC1, value));
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u6446\u98ce\u529f\u80fd\u8bbe\u5b9a", value);
            result.put("\u6446\u98ce\u529f\u80fd\u8bbe\u5b9a-TEXT", TypeValueUtils.getTypeValueText(Type.EC2, value));
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5c4f\u853d\u672c\u5730\u64cd\u4f5c", value);
            result.put("\u5c4f\u853d\u672c\u5730\u64cd\u4f5c-TEXT", TypeValueUtils.getTypeValueText(Type.EC3, value));
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u53cc\u673a\u5907\u4efd\u5207\u6362\u65f6\u95f4", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u9ad8\u6e29\u540c\u5f00\u6e29\u5ea6\u8bbe\u5b9a", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5236\u70ed\u6a21\u5f0f\u6e29\u5ea6\u8bbe\u5b9a\u503c", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5236\u51b7\u6e29\u63a7\u7cbe\u5ea6", value);
        }
        value = ValueUtils.decodeInteger(data, index);
        index += 2;
        if (value != 8224) {
            result.put("\u5236\u70ed\u6e29\u63a7\u7cbe\u5ea6", value);
        }
        return result;
    }
}

