/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haiwu.air.v100;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.telecom.core.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u57fa\u7ad9\u7a7a\u8c03(V1.00)", manufacturer="\u5e7f\u4e1c\u6d77\u609f\u79d1\u6280\u6709\u9650\u516c\u53f8")
public class GetVersion {
    @FoxEdgeOperate(name="\u8bfb\u53d6\u7248\u672c\u53f7", polling=true, type="encoder", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:devAddr");
        }
        PduEntity pduEntity = new PduEntity();
        pduEntity.setAddr(devAddr.intValue());
        pduEntity.setVer(16);
        pduEntity.setCid1(96);
        pduEntity.setCid2(79);
        byte[] pdu = PduEntity.encodePdu((PduEntity)pduEntity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u8bfb\u53d6\u7248\u672c\u53f7", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu((byte[])pdu);
        if (entity.getCid1() != 96) {
            throw new ProtocolException("\u8fd4\u56de\u7684CID1\u4e0d\u6b63\u786e!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("\u7248\u672c\u53f7", String.format("%1x.%1x", entity.getVer() / 16, entity.getVer() % 16));
        return result;
    }
}

