/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haier.ycj.a002.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;

public class PduEntity {
    private int hostAddr = 255;
    private int devAddr = 0;
    private int cmd = 0;
    private byte[] data = new byte[0];

    public static byte[] encodePdu(PduEntity entity) {
        byte[] pdu = new byte[entity.data.length + 10];
        int index = 0;
        pdu[index++] = -12;
        pdu[index++] = -11;
        pdu[index++] = (byte)(entity.data.length + 6);
        pdu[index++] = (byte)(entity.hostAddr >> 8 & 0xFF);
        pdu[index++] = (byte)(entity.hostAddr >> 0 & 0xFF);
        pdu[index++] = (byte)(entity.devAddr >> 8 & 0xFF);
        pdu[index++] = (byte)(entity.devAddr >> 0 & 0xFF);
        pdu[index++] = (byte)entity.cmd;
        System.arraycopy(entity.data, 0, pdu, index, entity.data.length);
        index += entity.data.length;
        pdu[index++] = PduEntity.getVerify(pdu);
        pdu[index++] = -5;
        return pdu;
    }

    public static PduEntity decodePdu(byte[] pdu) {
        if (pdu == null || pdu.length < 10) {
            throw new ProtocolException("\u62a5\u6587\u5927\u5c0f\u5c0f\u4e8e10");
        }
        if (pdu[0] != -12 || pdu[1] != -11) {
            throw new ProtocolException("\u5305\u5934\u5fc5\u987b\u4e3a F4 F5");
        }
        int length = pdu[2] & 0xFF;
        if (pdu.length < length + 4 || length < 6) {
            throw new ProtocolException("\u5e27\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        if (pdu[length + 3] != -5) {
            throw new ProtocolException("\u5305\u5c3e\u5fc5\u987b\u4e3a FB");
        }
        PduEntity entity = new PduEntity();
        entity.setData(new byte[length - 6]);
        entity.hostAddr = (pdu[3] & 0xFF) * 256 + (pdu[4] & 0xFF);
        entity.devAddr = (pdu[5] & 0xFF) * 256 + (pdu[6] & 0xFF);
        entity.cmd = pdu[7] & 0xFF;
        System.arraycopy(pdu, 8, entity.data, 0, entity.data.length);
        if (pdu[length + 2] != PduEntity.getVerify(pdu)) {
            throw new ProtocolException("\u6821\u9a8c\u548c\u4e0d\u6b63\u786e");
        }
        return entity;
    }

    private static byte getVerify(byte[] pdu) {
        int sum = 0;
        for (int i = 0; i < pdu.length - 4; ++i) {
            sum += pdu[i + 2] & 0xFF;
        }
        return (byte)sum;
    }

    public int getHostAddr() {
        return this.hostAddr;
    }

    public int getDevAddr() {
        return this.devAddr;
    }

    public int getCmd() {
        return this.cmd;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setHostAddr(int hostAddr) {
        this.hostAddr = hostAddr;
    }

    public void setDevAddr(int devAddr) {
        this.devAddr = devAddr;
    }

    public void setCmd(int cmd) {
        this.cmd = cmd;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

