/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haier.ycj.a002;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.entity.PduEntity;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.enums.Mode;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.enums.Speed;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u6d77\u5c14\u7a7a\u8c03-YCJ-A000", manufacturer="\u6d77\u5c14\u96c6\u56e2\u516c\u53f8")
public class YcjA002SetControlStatus {
    @FoxEdgeOperate(name="\u63a7\u5236", polling=true, type="encoder", mode="status", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Speed sp;
        String mode = (String)param.get("mode");
        Integer temp = (Integer)param.get("temp");
        Boolean open = (Boolean)param.get("open");
        Boolean damper = (Boolean)param.get("damper");
        String speed = (String)param.get("speed");
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{mode, temp, open, damper, speed, devAddr})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1amode, temp, open, damper, speed, devAddr");
        }
        PduEntity entity = new PduEntity();
        entity.setCmd(1);
        entity.setDevAddr(devAddr);
        entity.setData(new byte[2]);
        byte dat0 = 0;
        byte dat1 = 0;
        dat0 = (byte)(temp & 0xF);
        Mode md = Mode.getEnum(mode);
        if (md != null) {
            dat0 = (byte)(dat0 | md.getCode());
        }
        if (open.booleanValue()) {
            dat0 = (byte)(dat0 | 0xFFFFFF80);
        }
        if ((sp = Speed.getEnum(speed)) == null) {
            sp = Speed.value0;
        }
        dat1 = (byte)(dat1 | (byte)sp.getCode());
        if (damper.booleanValue()) {
            dat1 = (byte)(dat1 | 8);
        }
        entity.getData()[0] = dat0;
        entity.getData()[1] = dat1;
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u63a7\u5236", polling=true, type="decoder", mode="status", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getDevAddr());
        result.put("success", entity.getCmd() == 16);
        return result;
    }
}

