/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haier.ycj.a002;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.entity.PduEntity;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.enums.Fault;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u6d77\u5c14\u7a7a\u8c03-YCJ-A000", manufacturer="\u6d77\u5c14\u96c6\u56e2\u516c\u53f8")
public class YcjA002GetMonitorStatus {
    @FoxEdgeOperate(name="\u67e5\u8be2\u7cfb\u7edf\u76d1\u89c6\u72b6\u6001", polling=true, type="encoder", mode="status", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1adevAddr");
        }
        PduEntity entity = new PduEntity();
        entity.setCmd(62);
        entity.setDevAddr(devAddr);
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u67e5\u8be2\u7cfb\u7edf\u76d1\u89c6\u72b6\u6001", polling=true, type="decoder", mode="status", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        if (entity.getCmd() != 62) {
            throw new ProtocolException("\u8fd4\u56de\u7684\u547d\u4ee4\u5b57\u4e0d\u6b63\u786e!");
        }
        if (entity.getData().length != 4) {
            throw new ProtocolException("\u8fd4\u56de\u7684\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getDevAddr());
        byte dat0 = entity.getData()[0];
        Fault fault = Fault.getEnum(dat0 & 0x1F);
        if (fault == null) {
            fault = Fault.value0;
        }
        result.put("\u4e3b\u673a\u6545\u969c\u4fe1\u606f", fault.getName());
        result.put("\u4e3b\u673a\u5f00\u5173\u673a\u68c0\u6d4b", (dat0 & 0x20) != 0);
        result.put("\u68c0\u6d4b\u5668\u505c\u7535\u8865\u507f\u68c0\u6d4b", (dat0 & 0x40) != 0);
        result.put("\u7a7a\u8c03\u5668\u505c\u7535\u8865\u507f\u68c0\u6d4b", (dat0 & 0x80) != 0);
        byte dat1 = entity.getData()[1];
        if ((dat1 & 0xFF) == 0) {
            result.put("\u6e29\u5ea6\u4f20\u611f\u5668", "\u4f20\u611f\u5668\u5f00\u8def");
        } else if ((dat1 & 0xFF) == 15) {
            result.put("\u6e29\u5ea6\u4f20\u611f\u5668", "\u672a\u8bbe\u8be5\u4f20\u611f\u5668");
        } else if ((dat1 & 0xFF) == 255) {
            result.put("\u6e29\u5ea6\u4f20\u611f\u5668", "\u4f20\u611f\u5668\u77ed\u8def");
        } else {
            result.put("\u6e29\u5ea6\u4f20\u611f\u5668", (dat1 & 0xFF) - 64 + "\u2103");
        }
        byte dat2 = entity.getData()[2];
        fault = Fault.getEnum(dat2 & 0x1F);
        if (fault == null) {
            fault = Fault.value0;
        }
        result.put("\u4ece\u673a\u6545\u969c\u4fe1\u606f", fault.getName());
        result.put("\u4ece\u673a\u5f00\u5173\u673a\u68c0\u6d4b", (dat2 & 0x20) != 0);
        result.put("\u7535\u5b50\u9501", (dat2 & 0x40) != 0);
        result.put("\u63a7\u5236\u4fe1\u606f\u91cd\u7f6e\u6807\u5fd7", (dat2 & 0x80) != 0);
        byte dat3 = entity.getData()[3];
        result.put("\u6e7f\u5ea6\u68c0\u6d4b", dat3 & 0xFF);
        return result;
    }
}

