/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.haier.ycj.a002;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.entity.PduEntity;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.enums.Mode;
import cn.foxtech.device.protocol.v1.haier.ycj.a002.enums.Speed;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u6d77\u5c14\u7a7a\u8c03-YCJ-A000", manufacturer="\u6d77\u5c14\u96c6\u56e2\u516c\u53f8")
public class YcjA002GetControlStatus {
    @FoxEdgeOperate(name="\u67e5\u8be2\u63a7\u5236\u72b6\u6001\u76d1\u89c6", polling=true, type="encoder", mode="status", timeout=2000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1adevAddr");
        }
        PduEntity entity = new PduEntity();
        entity.setCmd(61);
        entity.setDevAddr(devAddr);
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u67e5\u8be2\u63a7\u5236\u72b6\u6001\u76d1\u89c6", polling=true, type="decoder", mode="status", timeout=2000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        if (entity.getCmd() != 61) {
            throw new ProtocolException("\u8fd4\u56de\u7684\u547d\u4ee4\u5b57\u4e0d\u6b63\u786e!");
        }
        if (entity.getData().length != 4) {
            throw new ProtocolException("\u8fd4\u56de\u7684\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getDevAddr());
        byte dat0 = entity.getData()[0];
        result.put("\u8bbe\u5b9a\u6e29\u5ea6", dat0 & 0x1F);
        Mode mode = Mode.getEnum(dat0 >> 4 & 7);
        if (mode == null) {
            mode = Mode.value0;
        }
        result.put("\u8fd0\u884c\u6a21\u5f0f", mode.getName());
        result.put("\u5f00\u5173\u673a\u6807\u5fd7", (dat0 & 0x80) != 0);
        byte dat1 = entity.getData()[1];
        Speed speed = Speed.getEnum(dat1 & 7);
        if (speed == null) {
            speed = Speed.value0;
        }
        result.put("\u8fd0\u884c\u6a21\u5f0f", speed.getName());
        result.put("\u98ce\u95e8\u6446\u52a8\u6807\u5fd7", (dat1 & 8) != 0);
        byte dat2 = entity.getData()[2];
        if ((dat2 & 3) == 0) {
            result.put("\u6362\u65b0\u98ce", "\u65e0");
        }
        if ((dat2 & 3) == 1) {
            result.put("\u6362\u65b0\u98ce", "\u81ea\u52a8");
        }
        if ((dat2 & 3) == 2) {
            result.put("\u6362\u65b0\u98ce", "\u8fde\u7eed");
        }
        if ((dat2 & 3) == 3) {
            result.put("\u6362\u65b0\u98ce", "\u65e0");
        }
        if ((dat2 >> 2 & 3) == 0) {
            result.put("\u5f3a\u529b\u5b89\u9759\u6307\u793a", "\u65e0");
        }
        if ((dat2 >> 2 & 3) == 1) {
            result.put("\u5f3a\u529b\u5b89\u9759\u6307\u793a", "\u5f3a\u529b");
        }
        if ((dat2 >> 2 & 3) == 2) {
            result.put("\u5f3a\u529b\u5b89\u9759\u6307\u793a", "\u5b89\u9759");
        }
        if ((dat2 >> 2 & 3) == 3) {
            result.put("\u5f3a\u529b\u5b89\u9759\u6307\u793a", "\u65e0");
        }
        result.put("\u52a0\u6e7f", (dat2 >> 4 & 1) == 1);
        result.put("\u8f85\u52a9\u7535\u52a0\u70ed", (dat2 >> 5 & 1) == 1);
        result.put("\u7a7a\u6c14\u6e05\u65b0", (dat2 >> 6 & 1) == 1);
        result.put("\u5065\u5eb7", (dat2 >> 7 & 1) == 1);
        byte dat3 = entity.getData()[3];
        result.put("\u6e7f\u5ea6\u8bbe\u5b9a", (dat3 >> 0 & 0x3F) + 29);
        if ((dat3 >> 6 & 3) == 0) {
            result.put("\u7acb\u4f53\u9001\u98ce", "\u505c\u6b62");
        }
        if ((dat3 >> 6 & 3) == 1) {
            result.put("\u7acb\u4f53\u9001\u98ce", "\u4e0a\u4e0b\u6446\u98ce");
        }
        if ((dat3 >> 6 & 3) == 2) {
            result.put("\u7acb\u4f53\u9001\u98ce", "\u5de6\u53f3\u6446\u98ce");
        }
        if ((dat3 >> 6 & 3) == 3) {
            result.put("\u7acb\u4f53\u9001\u98ce", "\u7acb\u4f53\u6446\u98ce");
        }
        return result;
    }
}

