/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.gdana.digester;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterEntity;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterProtocolFrame;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u5168\u81ea\u52a8\u6d88\u89e3\u63a7\u5236\u5668", manufacturer="\u5e7f\u5dde\u683c\u4e39\u7eb3\u4eea\u5668\u6709\u9650\u516c\u53f8")
public class DigesterProtocolConstantVolume {
    @FoxEdgeOperate(name="\u5b9a\u5bb9", type="encoder")
    public static String encodePack(Map<String, Object> param) {
        Integer deviceAddress = (Integer)param.get("\u8bbe\u5907\u5730\u5740");
        Integer subDeviceAddress = (Integer)param.get("\u5b50\u8bbe\u5907\u5730\u5740");
        if (deviceAddress == null || subDeviceAddress == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u8bbe\u5907\u5730\u5740/\u5b50\u8bbe\u5907\u5730\u5740");
        }
        DigesterEntity entity = new DigesterEntity();
        entity.setAddr(deviceAddress);
        entity.setSubAddr(subDeviceAddress);
        entity.setFunc(1);
        byte[] pack = DigesterProtocolFrame.encodePack(entity);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeOperate(name="\u5b9a\u5bb9", type="decoder", timeout=2000)
    public static Map<String, Object> decodePack(String hexString, Map<String, Object> param) {
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        DigesterEntity entity = DigesterProtocolFrame.decodePack(pack);
        if (entity == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (entity.getFunc() != -126) {
            throw new ProtocolException("\u8bbe\u5907\u62d2\u7edd\uff01");
        }
        byte[] dat = entity.getData();
        boolean sample = dat[0] != 0;
        boolean plate = dat[1] != 0;
        boolean stick = dat[2] != 0;
        boolean interval = dat[3] != 0;
        boolean spark = dat[4] != 0;
        boolean box = dat[5] != 0;
        int tempH = dat[6] & 0xFF;
        int tempL = dat[7] & 0xFF;
        int temp = (tempH * 256 + tempL) / 10;
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("sample", sample);
        value.put("plate", plate);
        value.put("stick", stick);
        value.put("interval", interval);
        value.put("spark", spark);
        value.put("box", box);
        value.put("temp", temp);
        return value;
    }
}

