/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.gdana.digester;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterEntity;
import java.util.ArrayList;
import java.util.List;

public class DigesterProtocolFrame {
    public static byte[] encodeBroadcast() {
        byte[] pack = new byte[]{-1, -1, -1, -1, -1, -1, 0, 0, 81, 11};
        return pack;
    }

    public static byte[] encodePack(DigesterEntity entity) {
        byte[] pack = new byte[entity.getData().length + 10];
        pack[0] = (byte)DigesterProtocolFrame.encodeBcd(entity.getAddr() % 1000000 / 10000);
        pack[1] = (byte)DigesterProtocolFrame.encodeBcd(entity.getAddr() % 10000 / 100);
        pack[2] = (byte)DigesterProtocolFrame.encodeBcd(entity.getAddr() % 100 / 1);
        pack[3] = (byte)DigesterProtocolFrame.encodeBcd(entity.getSubAddr());
        pack[4] = 0;
        pack[5] = 0;
        pack[6] = (byte)entity.getFunc();
        pack[7] = (byte)entity.getData().length;
        System.arraycopy(entity.getData(), 0, pack, 8, entity.getData().length);
        int crc16 = DigesterProtocolFrame.getCRC16(pack);
        pack[pack.length - 2] = (byte)(crc16 >> 0 & 0xFF);
        pack[pack.length - 1] = (byte)(crc16 >> 8 & 0xFF);
        return pack;
    }

    public static DigesterEntity decodePack(byte[] pack) {
        if (pack.length < 10) {
            return null;
        }
        DigesterEntity entity = new DigesterEntity();
        int adr = 0;
        adr = adr * 100 + DigesterProtocolFrame.decodeBcd(pack[0]);
        adr = adr * 100 + DigesterProtocolFrame.decodeBcd(pack[1]);
        adr = adr * 100 + DigesterProtocolFrame.decodeBcd(pack[2]);
        entity.setAddr(adr);
        entity.setSubAddr(DigesterProtocolFrame.decodeBcd(pack[3]));
        entity.setFunc(pack[6] & 0xFF);
        entity.setData(new byte[pack.length - 10]);
        System.arraycopy(pack, 8, entity.getData(), 0, entity.getData().length);
        int crc16 = DigesterProtocolFrame.getCRC16(pack);
        byte crcL = (byte)(crc16 >> 0 & 0xFF);
        byte crcH = (byte)(crc16 >> 8 & 0xFF);
        if (pack[pack.length - 2] == crcL && pack[pack.length - 2] == crcL) {
            return entity;
        }
        return null;
    }

    public static List<DigesterEntity> decodeStickPack(byte[] pack) {
        ArrayList<DigesterEntity> entityList = new ArrayList<DigesterEntity>();
        if (pack.length < 10) {
            throw new ProtocolException("\u89e3\u7801\u5931\u8d25!");
        }
        if (pack.length >= 10) {
            byte datLen2;
            int packLen2;
            byte datLen1 = pack[7];
            int packLen1 = datLen1 + 10;
            if (pack.length == packLen1) {
                DigesterEntity entity = DigesterProtocolFrame.decodePack(pack);
                if (entity == null) {
                    throw new ProtocolException("\u89e3\u7801\u5931\u8d25!");
                }
                entityList.add(entity);
                return entityList;
            }
            if (pack.length >= packLen1 + 10 && pack.length == packLen1 + (packLen2 = (datLen2 = pack[packLen1 + 7]) + 10)) {
                byte[] pack1 = new byte[packLen1];
                byte[] pack2 = new byte[packLen2];
                System.arraycopy(pack, 0, pack1, 0, pack1.length);
                System.arraycopy(pack, pack1.length, pack2, 0, pack2.length);
                DigesterEntity entity = DigesterProtocolFrame.decodePack(pack1);
                if (entity == null) {
                    throw new ProtocolException("\u89e3\u7801\u5931\u8d25!");
                }
                entityList.add(entity);
                entity = DigesterProtocolFrame.decodePack(pack2);
                if (entity == null) {
                    throw new ProtocolException("\u89e3\u7801\u5931\u8d25!");
                }
                entityList.add(entity);
                return entityList;
            }
        }
        throw new ProtocolException("\u89e3\u7801\u5931\u8d25!");
    }

    public static int decodeBcd(byte bcd) {
        return ((bcd & 0xFF) >> 4) * 10 + (bcd & 0xF);
    }

    public static int encodeBcd(int dec) {
        return dec % 10 + (dec % 100 / 10 << 4);
    }

    private static int getCRC16(byte[] arrCmd) {
        int iCount = arrCmd.length - 2;
        int CRC16Lo = 255;
        int CRC16Hi = 255;
        for (int n = 0; n < iCount; n = (int)((byte)(n + 1))) {
            CRC16Lo ^= arrCmd[n] & 0xFF;
            for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                int save_hi = CRC16Hi;
                int save_lo = CRC16Lo;
                CRC16Hi >>= 1;
                CRC16Lo >>= 1;
                if ((save_hi & 1) != 0) {
                    CRC16Lo |= 0x80;
                }
                if ((save_lo & 1) == 0) continue;
                CRC16Hi ^= 0x84;
                CRC16Lo ^= 8;
            }
        }
        return CRC16Hi * 256 + CRC16Lo;
    }

    public static byte decodeCmd(byte cmd) {
        return (byte)(cmd & 0xF);
    }
}

