/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.gdana.digester;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterEntity;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterProtocolFrame;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u5168\u81ea\u52a8\u6d88\u89e3\u63a7\u5236\u5668", manufacturer="\u5e7f\u5dde\u683c\u4e39\u7eb3\u4eea\u5668\u6709\u9650\u516c\u53f8")
public class DigesterProtocolSupport {
    @FoxEdgeOperate(name="\u64cd\u4f5c\u652f\u67b6", type="encoder")
    public static String encodePack(Map<String, Object> param) {
        Integer deviceAddress = (Integer)param.get("\u8bbe\u5907\u5730\u5740");
        Integer subDeviceAddress = (Integer)param.get("\u5b50\u8bbe\u5907\u5730\u5740");
        if (deviceAddress == null || subDeviceAddress == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u8bbe\u5907\u5730\u5740/\u5b50\u8bbe\u5907\u5730\u5740");
        }
        Integer number = (Integer)param.get("\u652f\u67b6\u7f16\u53f7");
        if (number == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u652f\u67b6\u7f16\u53f7");
        }
        String flag = (String)param.get("\u6807\u8bb0");
        if (flag == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u6807\u8bb0");
        }
        DigesterEntity entity = new DigesterEntity();
        entity.setAddr(deviceAddress);
        entity.setSubAddr(subDeviceAddress);
        entity.setFunc(20);
        entity.setData(new byte[2]);
        entity.getData()[0] = number.byteValue();
        if (flag.equals("\u62ac\u5347")) {
            entity.getData()[1] = 1;
        } else if (flag.equals("\u590d\u4f4d")) {
            entity.getData()[1] = 0;
        } else {
            throw new ProtocolException("\u6807\u8bb0\u8303\u56f4:\u62ac\u5347/\u590d\u4f4d");
        }
        byte[] pack = DigesterProtocolFrame.encodePack(entity);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeOperate(name="\u64cd\u4f5c\u652f\u67b6", type="decoder", mode="result", timeout=2000)
    public static Map<String, Object> decodePack(String hexString, Map<String, Object> param) {
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        DigesterEntity entity = DigesterProtocolFrame.decodePack(pack);
        if (entity == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (entity.getFunc() != 148) {
            throw new ProtocolException("\u8bbe\u5907\u62d2\u7edd\uff01");
        }
        byte[] dat = entity.getData();
        if (dat.length != 1) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("\u64cd\u4f5c\u7ed3\u679c", dat[0] == 1);
        return value;
    }
}

