/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.gdana.digester;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterEntity;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterProtocolFrame;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u5168\u81ea\u52a8\u6d88\u89e3\u63a7\u5236\u5668", manufacturer="\u5e7f\u5dde\u683c\u4e39\u7eb3\u4eea\u5668\u6709\u9650\u516c\u53f8")
public class DigesterProtocolCheckDeviceStatus {
    @FoxEdgeOperate(name="\u68c0\u67e5\u8bbe\u5907\u72b6\u6001", type="encoder")
    public static String encodePack(Map<String, Object> param) {
        Integer deviceAddress = (Integer)param.get("\u8bbe\u5907\u5730\u5740");
        Integer subDeviceAddress = (Integer)param.get("\u5b50\u8bbe\u5907\u5730\u5740");
        if (deviceAddress == null || subDeviceAddress == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u8bbe\u5907\u5730\u5740/\u5b50\u8bbe\u5907\u5730\u5740");
        }
        DigesterEntity entity = new DigesterEntity();
        entity.setAddr(deviceAddress);
        entity.setSubAddr(subDeviceAddress);
        entity.setFunc(1);
        byte[] pack = DigesterProtocolFrame.encodePack(entity);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeOperate(name="\u68c0\u67e5\u8bbe\u5907\u72b6\u6001", type="decoder", timeout=2000)
    public static Map<String, Object> decodePack(String hexString, Map<String, Object> param) {
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        DigesterEntity entity = DigesterProtocolFrame.decodePack(pack);
        if (entity == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (entity.getFunc() != 129) {
            throw new ProtocolException("\u8bbe\u5907\u62d2\u7edd\uff01");
        }
        byte[] dat = entity.getData();
        if (dat.length != 15) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11; ++i) {
            sb.append((char)dat[i]);
        }
        value.put("\u8bbe\u5907\u540d\u79f0", sb.toString());
        value.put("\u8bbe\u5907\u7a7a\u95f2", dat[11] == 0);
        value.put("\u770b\u95e8\u72d7\u590d\u4f4d", dat[12] == 1);
        value.put("\u6d88\u89e3\u4eea\u5b54\u6570", DigesterProtocolFrame.decodeBcd(dat[13]));
        return value;
    }
}

