/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.gdana.digester;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterEntity;
import cn.foxtech.device.protocol.v1.gdana.digester.DigesterProtocolFrame;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FoxEdgeDeviceType(value="\u5168\u81ea\u52a8\u6d88\u89e3\u63a7\u5236\u5668", manufacturer="\u5e7f\u5dde\u683c\u4e39\u7eb3\u4eea\u5668\u6709\u9650\u516c\u53f8")
public class DigesterProtocolAddSample {
    @FoxEdgeOperate(name="\u6dfb\u52a0\u6837\u672c", type="encoder")
    public static String encodePack(Map<String, Object> param) {
        Integer deviceAddress = (Integer)param.get("\u8bbe\u5907\u5730\u5740");
        Integer subDeviceAddress = (Integer)param.get("\u5b50\u8bbe\u5907\u5730\u5740");
        if (deviceAddress == null || subDeviceAddress == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u8bbe\u5907\u5730\u5740/\u5b50\u8bbe\u5907\u5730\u5740");
        }
        Integer speed = (Integer)param.get("\u901f\u5ea6\u6863\u4f4d");
        List infoList = (List)param.get("\u5b54\u4f4d\u53c2\u6570");
        if (speed == null || infoList == null) {
            throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u901f\u5ea6\u6863\u4f4d/\u5b54\u4f4d\u53c2\u6570");
        }
        DigesterEntity entity = new DigesterEntity();
        entity.setAddr(deviceAddress);
        entity.setSubAddr(subDeviceAddress);
        entity.setFunc(19);
        entity.setData(new byte[1 + 4 * infoList.size()]);
        byte[] data = entity.getData();
        int index = 0;
        data[0] = speed.byteValue();
        for (Map info : infoList) {
            Integer number = (Integer)info.get("\u5b54\u4f4d");
            Integer channel = (Integer)info.get("\u8bd5\u5242\u901a\u9053");
            Integer vol = (Integer)info.get("\u4f53\u79ef");
            if (number == null || channel == null || vol == null) {
                throw new ProtocolException("\u7f3a\u5931\u53c2\u6570:\u5b54\u4f4d/\u8bd5\u5242\u901a\u9053/\u4f53\u79ef");
            }
            data[1 + index * 4] = number.byteValue();
            data[2 + index * 4] = channel.byteValue();
            data[3 + index * 4] = (byte)(vol >> 8 & 0xFF);
            data[4 + index * 4] = (byte)(vol >> 0 & 0xFF);
            ++index;
        }
        byte[] pack = DigesterProtocolFrame.encodePack(entity);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeOperate(name="\u6dfb\u52a0\u6837\u672c", type="decoder", mode="result", timeout=2000)
    public static Map<String, Object> decodePack(String hexString, Map<String, Object> param) {
        byte[] pack = HexUtils.hexStringToByteArray((String)hexString);
        DigesterEntity entity = DigesterProtocolFrame.decodePack(pack);
        if (entity == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (entity.getFunc() != 147) {
            throw new ProtocolException("\u8bbe\u5907\u62d2\u7edd\uff01");
        }
        byte[] data = entity.getData();
        if (data.length % 5 != 0) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < data.length / 5; ++i) {
            HashMap<String, Comparable<Byte>> info = new HashMap<String, Comparable<Byte>>();
            info.put("\u5b54\u4f4d", Byte.valueOf(data[0 + i * 5]));
            info.put("\u64cd\u4f5c\u6210\u529f", Boolean.valueOf(data[1 + i * 5] == 1));
            info.put("\u8bd5\u5242\u901a\u9053", Byte.valueOf(data[2 + i * 5]));
            info.put("\u4f53\u79ef", Integer.valueOf(((data[3 + i * 5] & 0xFF) << 8) + (data[4 + i * 5] & 0xFF)));
            result.add(info);
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("\u64cd\u4f5c\u7ed3\u679c", result);
        return value;
    }
}

