/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dlt645;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeReport;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dlt645.core.DLT645Protocol;
import cn.foxtech.device.protocol.v1.dlt645.core.DLT645Template;
import cn.foxtech.device.protocol.v1.dlt645.core.entity.DLT645FunEntity;
import cn.foxtech.device.protocol.v1.dlt645.core.entity.DLT645v1997DataEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="DLT645 v1997", manufacturer="Fox Edge")
public class DLT645v1997ProtocolReportData {
    @FoxEdgeReport(type="alarm")
    @FoxEdgeOperate(name="\u4e0a\u62a5\u6570\u636e", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadData(String hexString, Map<String, Object> param) {
        String tableName = (String)param.get("tableName");
        if (MethodUtils.hasNull((Object[])new Object[]{tableName})) {
            throw new ProtocolException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:tableName");
        }
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        Map value = DLT645Protocol.unPackCmd2Map((byte[])arrCmd);
        if (value == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        byte func = (Byte)value.get("FUN");
        DLT645FunEntity entity = DLT645FunEntity.decodeEntity((byte)func);
        if (entity.isError()) {
            throw new ProtocolException("\u8bbe\u5907\u8fd4\u56de\u51fa\u9519\u4ee3\u7801\uff1a" + HexUtils.byteArrayToHexString((byte[])((byte[])value.get("DAT"))));
        }
        byte[] data = (byte[])value.get("DAT");
        DLT645v1997DataEntity dataEntity = new DLT645v1997DataEntity();
        dataEntity.decodeValue(data, DLT645Template.inst().getTemplateByDIn("v1997", tableName));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(dataEntity.getName(), dataEntity.getValue());
        if (dataEntity.getValue2nd() != null) {
            result.put(dataEntity.getName() + ":\u76f8\u5173\u503c", dataEntity.getValue2nd());
        }
        return result;
    }
}

