/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.dlt645;

import cn.foxtech.device.protocol.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.core.exception.ProtocolException;
import cn.foxtech.device.protocol.core.utils.HexUtils;
import cn.foxtech.device.protocol.core.utils.MethodUtils;
import cn.foxtech.device.protocol.dlt645.core.DLT645Protocol;
import cn.foxtech.device.protocol.dlt645.core.DLT645Template;
import cn.foxtech.device.protocol.dlt645.core.entity.DLT645DataEntity;
import cn.foxtech.device.protocol.dlt645.core.entity.DLT645FunEntity;
import cn.foxtech.device.protocol.dlt645.core.entity.DLT645v1997DataEntity;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="DLT645 v1997", manufacturer="Fox Edge")
public class DLT645v1997ProtocolReadData {
    @FoxEdgeOperate(name="\u8bfb\u6570\u636e", polling=true, type="encoder", timeout=2000)
    public static String packReadData(Map<String, Object> param) {
        String deviceAddress = (String)param.get("deviceAddress");
        String objectName = (String)param.get("objectName");
        String tableName = (String)param.get("tableName");
        if (MethodUtils.hasNull((Object[])new Object[]{deviceAddress, objectName, tableName})) {
            throw new ProtocolException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:deviceAddress, objectName, tableName");
        }
        byte[] tmp = HexUtils.hexStringToByteArray((String)deviceAddress);
        byte[] adrr = new byte[6];
        System.arraycopy(tmp, 0, adrr, 0, Math.min(tmp.length, adrr.length));
        for (int i = 0; i < adrr.length / 2; ++i) {
            byte by = adrr[i];
            adrr[i] = adrr[5 - i];
            adrr[5 - i] = by;
        }
        DLT645DataEntity dataEntity = (DLT645DataEntity)DLT645Template.inst().getTemplateByName("v1997", tableName).get(objectName);
        if (dataEntity == null) {
            throw new ProtocolException("CSV\u6a21\u677f\u6587\u4ef6: " + tableName + " \u4e2d\u672a\u5b9a\u4e49\u5bf9\u8c61:" + objectName + " \uff0c\u4f60\u9700\u8981\u5728\u6a21\u677f\u4e2d\u6dfb\u52a0\u8be5\u5bf9\u8c61\u4fe1\u606f");
        }
        param.put("ADR", adrr);
        param.put("FUN", DLT645FunEntity.getCodev1997((String)"\u8bfb\u6570\u636e"));
        param.put("DAT", dataEntity.getDIn());
        byte[] pack = DLT645Protocol.packCmd(param);
        return HexUtils.byteArrayToHexString((byte[])pack);
    }

    @FoxEdgeOperate(name="\u8bfb\u6570\u636e", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadData(String hexString, Map<String, Object> param) {
        String tableName = (String)param.get("tableName");
        if (MethodUtils.hasNull((Object[])new Object[]{tableName})) {
            throw new ProtocolException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:tableName");
        }
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        Map value = DLT645Protocol.unPackCmd2Map((byte[])arrCmd);
        if (value == null) {
            throw new ProtocolException("\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        byte func = (Byte)value.get("FUN");
        DLT645FunEntity entity = DLT645FunEntity.decodeEntity((byte)func);
        if (entity.isError()) {
            throw new ProtocolException("\u8bbe\u5907\u8fd4\u56de\u51fa\u9519\u4ee3\u7801\uff1a" + HexUtils.byteArrayToHexString((byte[])((byte[])value.get("DAT"))));
        }
        byte[] data = (byte[])value.get("DAT");
        DLT645v1997DataEntity dataEntity = new DLT645v1997DataEntity();
        dataEntity.decodeValue(data, DLT645Template.inst().getTemplateByDIn("v1997", tableName));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(dataEntity.getName(), dataEntity.getValue());
        if (dataEntity.getValue2nd() != null) {
            result.put(dataEntity.getName() + ":\u76f8\u5173\u503c", dataEntity.getValue2nd());
        }
        return result;
    }
}

