/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.object;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.ArrayList;
import java.util.List;

public class TlvObject {
    private int type = 0;
    private String value = "";

    public static List<TlvObject> decodeTlvList(byte[] data, int offset, int tlvsSize) {
        int index;
        int length;
        if (data.length < offset + tlvsSize) {
            throw new ProtocolException("TLV\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        ArrayList<TlvObject> tlvList = new ArrayList<TlvObject>();
        for (index = 0; index < tlvsSize; index += length) {
            int type = IntegerUtil.decodeInteger2byte(data, offset + index);
            index += 2;
            if (data.length < offset + (index += 2) + (length = IntegerUtil.decodeInteger2byte(data, offset + index))) {
                throw new ProtocolException("TLV\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e");
            }
            String txt = HexUtils.byteArrayToHexString((byte[])data, (int)(offset + index), (int)length, (boolean)false);
            TlvObject tlv = new TlvObject();
            tlv.setType(type);
            tlv.setValue(txt);
            tlvList.add(tlv);
        }
        if (index != tlvsSize) {
            throw new ProtocolException("TLV\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        return tlvList;
    }

    public int getEncodeLength() {
        String txt = this.value;
        if (0 <= txt.indexOf(" ")) {
            txt.replaceAll(" ", "");
        }
        txt = txt.substring(0, Math.min(this.value.length(), 131072));
        int length = 4 + txt.length() / 2;
        return length;
    }

    public int encode(byte[] data, int offset) {
        String txt = this.value;
        if (0 <= txt.indexOf(" ")) {
            txt.replaceAll(" ", "");
        }
        txt = txt.substring(0, Math.min(this.value.length(), 131072));
        int index = 0;
        IntegerUtil.encodeInteger2byte(this.type, data, offset + index);
        int length = txt.length() / 2;
        IntegerUtil.encodeInteger2byte(length, data, offset + (index += 2));
        HexUtils.hexStringToByteArray((String)txt, (byte[])data, (int)(offset + (index += 2)));
        return index += length;
    }

    public int getDecodeSize(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new ProtocolException("TLV\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e");
        }
        int length = IntegerUtil.decodeInteger2byte(data, offset + 2);
        return length;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

