/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.object;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.enums.ParFmt;
import cn.foxtech.device.protocol.v1.dahua.fire.core.enums.ParType;
import cn.foxtech.device.protocol.v1.utils.BcdUtils;
import cn.foxtech.device.protocol.v1.utils.ByteUtils;
import cn.foxtech.device.protocol.v1.utils.HexUtils;

public class ParVarObject {
    private ParType type = ParType.host;
    private String value = "";

    public int getSize() {
        String txt = this.value.substring(0, Math.min(this.value.length(), 250));
        if (this.type.getFmt().equals((Object)ParFmt.ascii)) {
            return txt.length();
        }
        if (this.type.getFmt().equals((Object)ParFmt.hex)) {
            String hex = txt.replaceAll(" ", "");
            return hex.length() / 2;
        }
        if (this.type.getFmt().equals((Object)ParFmt.bcd)) {
            String bcd = txt.replaceAll(" ", "");
            return bcd.length() / 2;
        }
        return 0;
    }

    public int encode(byte[] data, int offset) {
        String txt = this.value.substring(0, Math.min(this.value.length(), 250));
        data[offset + 0] = (byte)this.type.getType();
        if (this.type.getFmt().equals((Object)ParFmt.ascii)) {
            data[offset + 1] = (byte)txt.length();
            ByteUtils.encodeAscii((String)txt, (byte[])data, (int)(offset + 2), (int)txt.length(), (boolean)true);
            return data[offset + 1] & 0xFF;
        }
        if (this.type.getFmt().equals((Object)ParFmt.hex)) {
            String hex = txt.replaceAll(" ", "");
            data[offset + 1] = (byte)(hex.length() / 2);
            HexUtils.hexStringToByteArray((String)hex, (byte[])data, (int)(offset + 2));
            return data[offset + 1] & 0xFF;
        }
        if (this.type.getFmt().equals((Object)ParFmt.bcd)) {
            String bcd = txt.replaceAll(" ", "");
            data[offset + 1] = (byte)(bcd.length() / 2);
            BcdUtils.str2bcd((String)bcd, (byte[])data, (int)(offset + 2), (boolean)true);
            return data[offset + 1] & 0xFF;
        }
        return data[offset + 1] & 0xFF;
    }

    public void decode(byte[] data, int offset) {
        this.type = ParType.getEnum(data[offset + 0]);
        if (this.type == null) {
            throw new ProtocolException("\u672a\u5b9a\u4e49\u7684\u53c2\u6570\u7c7b\u578b\uff1a" + data[offset + 0]);
        }
        byte length = data[offset + 1];
        if (this.type.getFmt().equals((Object)ParFmt.ascii)) {
            this.value = ByteUtils.decodeAscii((byte[])data, (int)(offset + 2), (int)length, (boolean)true);
            return;
        }
        if (this.type.getFmt().equals((Object)ParFmt.hex)) {
            this.value = HexUtils.byteArrayToHexString((byte[])data, (int)(offset + 2), (int)length, (boolean)true);
            return;
        }
        if (this.type.getFmt().equals((Object)ParFmt.bcd)) {
            this.value = BcdUtils.bcd2str((byte[])data, (int)(offset + 2), (int)length, (boolean)true);
            return;
        }
    }

    public ParType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setType(ParType type) {
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

