/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.object;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.utils.ByteUtils;
import java.util.ArrayList;

public class AddrObject {
    private String ip = "";
    private String userName = "";
    private String password = "";
    private String filePath = "";
    private String fileName = "";
    private int reserve = 0;

    public static int getSize(byte[] data, int offset) {
        if (data.length < offset + 4) {
            throw new ProtocolException("\u5730\u5740\u5bf9\u8c61\u7684\u957f\u5ea6\uff0c\u6700\u5c0f\u4e3a9");
        }
        int length = 0;
        length += data[offset + 0] & 0xFF;
        length += data[offset + 1] & 0xFF;
        length += data[offset + 2] & 0xFF;
        return length += 4;
    }

    public int getSize() {
        String ip = this.ip.replaceAll(";", "") + ";";
        String filePath = this.filePath.replaceAll(";", "") + ";";
        String fileName = this.fileName.replaceAll(";", "") + ";";
        String userName = this.userName.replaceAll(";", "") + ";";
        String password = this.password.replaceAll(";", "") + ";";
        int length = 0;
        length += ip.length();
        length += filePath.length();
        if ((length += fileName.length()) > 256) {
            throw new ProtocolException("\u5730\u5740\u5bf9\u8c61\u4e2d\uff0cIP+\u6587\u4ef6\u8def\u5f84+\u6587\u4ef6\u540d\u79f0\u7684\u957f\u5ea6\uff0c\u8d85\u8fc7\u4e86255");
        }
        length += userName.length();
        length += password.length();
        return length += 4;
    }

    public int decode(byte[] data, int offset) {
        if (data.length < offset + 4 + 5) {
            throw new ProtocolException("\u5730\u5740\u5bf9\u8c61\u7684\u957f\u5ea6\uff0c\u6700\u5c0f\u4e3a9");
        }
        int index = 0;
        int len1 = data[offset + index] & 0xFF;
        int len2 = data[offset + ++index] & 0xFF;
        int len3 = data[offset + ++index] & 0xFF;
        this.reserve = data[offset + ++index] & 0xFF;
        ++index;
        if (data.length != offset + 4 + len1 + len2 + len3) {
            throw new ProtocolException("\u5730\u5740\u5bf9\u8c61\u7684\u957f\u5ea6\uff0c\u4e0d\u6b63\u786e!");
        }
        String txt = ByteUtils.decodeAscii((byte[])data, (int)(offset + 4), (int)(len1 + len2 + len3), (boolean)true);
        index += len1 + len2 + len3;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (txt.charAt(i) != ';') {
                sb.append(c);
                continue;
            }
            list.add(sb.toString());
        }
        if (list.size() != 5) {
            throw new ProtocolException("\u5730\u5740\u5bf9\u8c61\u7684\u5185\u5bb9\uff0c\u4e0d\u6b63\u786e!");
        }
        this.ip = (String)list.get(0);
        this.userName = (String)list.get(1);
        this.password = (String)list.get(2);
        this.filePath = (String)list.get(3);
        this.fileName = (String)list.get(4);
        return index;
    }

    public int encode(byte[] data, int offset) {
        String ip = this.ip.replaceAll(";", "") + ";";
        String filePath = this.filePath.replaceAll(";", "") + ";";
        String fileName = this.fileName.replaceAll(";", "") + ";";
        String userName = this.userName.replaceAll(";", "") + ";";
        String password = this.password.replaceAll(";", "") + ";";
        int index = 0;
        data[offset + index] = (byte)(ip.length() + filePath.length() + fileName.length());
        data[offset + ++index] = (byte)userName.length();
        data[offset + ++index] = (byte)password.length();
        data[offset + ++index] = (byte)this.reserve;
        ByteUtils.encodeAscii((String)ip, (byte[])data, (int)(offset + ++index), (int)ip.length(), (boolean)true);
        ByteUtils.encodeAscii((String)userName, (byte[])data, (int)(offset + (index += ip.length())), (int)userName.length(), (boolean)true);
        ByteUtils.encodeAscii((String)password, (byte[])data, (int)(offset + (index += userName.length())), (int)password.length(), (boolean)true);
        ByteUtils.encodeAscii((String)filePath, (byte[])data, (int)(offset + (index += password.length())), (int)filePath.length(), (boolean)true);
        ByteUtils.encodeAscii((String)fileName, (byte[])data, (int)(offset + (index += filePath.length())), (int)fileName.length(), (boolean)true);
        return index += fileName.length();
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getReserve() {
        return this.reserve;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setReserve(int reserve) {
        this.reserve = reserve;
    }
}

