/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.StringUtil;
import cn.foxtech.device.protocol.v1.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class InfObjUpgradeStatusEntity
extends InfObjEntity {
    private int sysType = 0;
    private int sysAddress = 0;
    private int compType = 0;
    private String compAddress = "";
    private int softwareType = 0;
    private int status = 0;

    public static void decodeEntity(byte[] data, InfObjUpgradeStatusEntity entity) {
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.sysType = data[index++] & 0xFF;
        entity.sysAddress = data[index++] & 0xFF;
        entity.compType = data[index++] & 0xFF;
        entity.compAddress = ByteUtils.decodeAscii((byte[])data, (int)index, (int)32, (boolean)true);
        index += 32;
        entity.softwareType = data[index++] & 0xFF;
        entity.status = data[index++] & 0xFF;
    }

    public static byte[] encodeEntity(InfObjUpgradeStatusEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.sysAddress;
        data[index++] = (byte)entity.compType;
        String compAddress = StringUtil.truncateString(entity.compAddress, 32);
        ByteUtils.encodeAscii((String)compAddress, (byte[])data, (int)index, (int)32, (boolean)true);
        index += 32;
        data[index++] = (byte)entity.softwareType;
        data[index++] = (byte)entity.status;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    public int size() {
        return 37;
    }

    @Override
    public void decode(byte[] data) {
        InfObjUpgradeStatusEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjUpgradeStatusEntity.encodeEntity(this);
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getSysAddress() {
        return this.sysAddress;
    }

    public int getCompType() {
        return this.compType;
    }

    public String getCompAddress() {
        return this.compAddress;
    }

    public int getSoftwareType() {
        return this.softwareType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setSysAddress(int sysAddress) {
        this.sysAddress = sysAddress;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public void setCompAddress(String compAddress) {
        this.compAddress = compAddress;
    }

    public void setSoftwareType(int softwareType) {
        this.softwareType = softwareType;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

