/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class InfObjSysAnalogEntity
extends InfObjEntity {
    private int sysType = 0;
    private int sysAddress = 0;
    private int analogType = 0;
    private int analogValue = 0;
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjSysAnalogEntity entity) {
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.sysType = data[index++] & 0xFF;
        entity.sysAddress = data[index++] & 0xFF;
        entity.analogType = IntegerUtil.decodeInteger2byte(data, index);
        entity.analogValue = IntegerUtil.decodeInteger2byte(data, index += 2);
        entity.time = TimeUtil.decodeTime6byte(data, index += 2);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjSysAnalogEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.sysAddress;
        IntegerUtil.encodeInteger2byte(entity.analogType, data, index);
        IntegerUtil.encodeInteger2byte(entity.analogValue, data, index += 2);
        TimeUtil.encodeTime6byte(entity.time, data, index += 2);
        index += 6;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    public int size() {
        return 12;
    }

    @Override
    public void decode(byte[] data) {
        InfObjSysAnalogEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjSysAnalogEntity.encodeEntity(this);
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getSysAddress() {
        return this.sysAddress;
    }

    public int getAnalogType() {
        return this.analogType;
    }

    public int getAnalogValue() {
        return this.analogValue;
    }

    public String getTime() {
        return this.time;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setSysAddress(int sysAddress) {
        this.sysAddress = sysAddress;
    }

    public void setAnalogType(int analogType) {
        this.analogType = analogType;
    }

    public void setAnalogValue(int analogValue) {
        this.analogValue = analogValue;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

