/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.StringUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.VersionUtil;
import cn.foxtech.device.protocol.v1.utils.BcdUtils;
import cn.foxtech.device.protocol.v1.utils.ByteUtils;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import java.util.ArrayList;
import java.util.List;

public class InfObjRegisterExEntity
extends InfObjEntity {
    private String protocolVersion = "1.00";
    private String imei = "";
    private long activeTime = 0L;
    private String softwareVersion = "1.00";
    private int tauTime = 0;
    private String sn = "";
    private String ccid = "";
    private double ratedVoltage = 0.0;
    private double underVoltage = 0.0;
    private int nbFreqBand = 0;
    private String imsi = "";
    private String cellId = "";
    private String apn = "";
    private String reserve1 = "";
    private int sysType = 0;
    private int reconnect = 0;
    private String deviceType = "";
    private String deviceUuid = "";
    private String reserve2 = "";

    public static void decodeEntity(byte[] data, InfObjRegisterExEntity entity) {
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.protocolVersion = VersionUtil.decodeVersion2byte(data, index);
        entity.imei = BcdUtils.bcd2str((byte[])data, (int)(index += 2), (int)8, (boolean)true);
        entity.activeTime = ByteUtils.decodeInt32((byte[])data, (int)(index += 8), (boolean)false);
        entity.softwareVersion = VersionUtil.decodeVersion2byte(data, index += 4);
        index += 2;
        int hv = data[index++] & 0xFF;
        int lv = data[index++] & 0xFF;
        entity.tauTime = hv * 100 + lv;
        entity.sn = ByteUtils.decodeAscii((byte[])data, (int)index, (int)16, (boolean)true);
        entity.ccid = BcdUtils.bcd2str((byte[])data, (int)(index += 16), (int)10, (boolean)true);
        entity.ratedVoltage = (double)ByteUtils.decodeInt16((byte[])data, (int)(index += 10), (boolean)false) * 0.1;
        entity.underVoltage = (double)ByteUtils.decodeInt16((byte[])data, (int)(index += 2), (boolean)false) * 0.1;
        index += 2;
        entity.nbFreqBand = data[index++] & 0xFF;
        entity.imsi = BcdUtils.bcd2str((byte[])data, (int)index, (int)8, (boolean)true);
        entity.cellId = BcdUtils.bcd2str((byte[])data, (int)(index += 8), (int)5, (boolean)true);
        entity.apn = ByteUtils.decodeAscii((byte[])data, (int)(index += 5), (int)10, (boolean)true);
        entity.reserve1 = HexUtils.byteArrayToHexString((byte[])data, (int)(index += 10), (int)4, (boolean)false);
        index += 4;
        entity.sysType = data[index++] & 0xFF;
        entity.reconnect = data[index++] & 0xFF;
        entity.deviceType = ByteUtils.decodeAscii((byte[])data, (int)index, (int)16, (boolean)true);
        entity.deviceUuid = ByteUtils.decodeAscii((byte[])data, (int)(index += 16), (int)12, (boolean)true);
        entity.reserve2 = HexUtils.byteArrayToHexString((byte[])data, (int)(index += 12), (int)4, (boolean)false);
        index += 4;
    }

    public static byte[] encodeEntity(InfObjRegisterExEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        VersionUtil.encodeVersion2byte(entity.protocolVersion, data, index);
        String imei = StringUtil.truncateString(entity.imei, 16);
        BcdUtils.str2bcd((String)imei, (byte[])data, (int)(index += 2), (boolean)true);
        ByteUtils.encodeInt32((long)entity.activeTime, (byte[])data, (int)(index += 8), (boolean)false);
        VersionUtil.encodeVersion2byte(entity.softwareVersion, data, index += 4);
        index += 2;
        data[index++] = (byte)(entity.tauTime / 100);
        data[index++] = (byte)(entity.tauTime % 100);
        String sn = StringUtil.truncateString(entity.sn, 16);
        ByteUtils.encodeAscii((String)sn, (byte[])data, (int)index, (int)16, (boolean)true);
        String ccid = StringUtil.truncateString(entity.ccid, 20);
        BcdUtils.str2bcd((String)ccid, (byte[])data, (int)(index += 16), (boolean)true);
        ByteUtils.encodeInt16((int)((int)(entity.ratedVoltage * 10.0)), (byte[])data, (int)(index += 10), (boolean)false);
        ByteUtils.encodeInt16((int)((int)(entity.underVoltage * 10.0)), (byte[])data, (int)(index += 2), (boolean)false);
        index += 2;
        data[index++] = (byte)entity.nbFreqBand;
        String imsi = StringUtil.truncateString(entity.imsi, 16);
        BcdUtils.str2bcd((String)imsi, (byte[])data, (int)index, (boolean)true);
        String cellId = StringUtil.truncateString(entity.cellId, 10);
        BcdUtils.str2bcd((String)cellId, (byte[])data, (int)(index += 8), (boolean)true);
        String apn = StringUtil.truncateString(entity.apn, 10);
        ByteUtils.encodeAscii((String)apn, (byte[])data, (int)(index += 5), (int)10, (boolean)true);
        String reserve1 = StringUtil.truncateString(entity.reserve1, 8);
        HexUtils.hexStringToByteArray((String)reserve1, (byte[])data, (int)(index += 10));
        index += 4;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.reconnect;
        String deviceType = StringUtil.truncateString(entity.deviceType, 16);
        ByteUtils.encodeAscii((String)deviceType, (byte[])data, (int)index, (int)16, (boolean)true);
        String deviceUuid = StringUtil.truncateString(entity.deviceUuid, 12);
        ByteUtils.encodeAscii((String)deviceType, (byte[])data, (int)(index += 16), (int)12, (boolean)true);
        String reserve2 = StringUtil.truncateString(entity.reserve2, 8);
        HexUtils.hexStringToByteArray((String)reserve2, (byte[])data, (int)(index += 12));
        index += 4;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    @Override
    public void decode(byte[] data) {
        InfObjRegisterExEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjRegisterExEntity.encodeEntity(this);
    }

    public int size() {
        return 110;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getImei() {
        return this.imei;
    }

    public long getActiveTime() {
        return this.activeTime;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public int getTauTime() {
        return this.tauTime;
    }

    public String getSn() {
        return this.sn;
    }

    public String getCcid() {
        return this.ccid;
    }

    public double getRatedVoltage() {
        return this.ratedVoltage;
    }

    public double getUnderVoltage() {
        return this.underVoltage;
    }

    public int getNbFreqBand() {
        return this.nbFreqBand;
    }

    public String getImsi() {
        return this.imsi;
    }

    public String getCellId() {
        return this.cellId;
    }

    public String getApn() {
        return this.apn;
    }

    public String getReserve1() {
        return this.reserve1;
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getReconnect() {
        return this.reconnect;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceUuid() {
        return this.deviceUuid;
    }

    public String getReserve2() {
        return this.reserve2;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public void setActiveTime(long activeTime) {
        this.activeTime = activeTime;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public void setTauTime(int tauTime) {
        this.tauTime = tauTime;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setCcid(String ccid) {
        this.ccid = ccid;
    }

    public void setRatedVoltage(double ratedVoltage) {
        this.ratedVoltage = ratedVoltage;
    }

    public void setUnderVoltage(double underVoltage) {
        this.underVoltage = underVoltage;
    }

    public void setNbFreqBand(int nbFreqBand) {
        this.nbFreqBand = nbFreqBand;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public void setCellId(String cellId) {
        this.cellId = cellId;
    }

    public void setApn(String apn) {
        this.apn = apn;
    }

    public void setReserve1(String reserve1) {
        this.reserve1 = reserve1;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setReconnect(int reconnect) {
        this.reconnect = reconnect;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceUuid(String deviceUuid) {
        this.deviceUuid = deviceUuid;
    }

    public void setReserve2(String reserve2) {
        this.reserve2 = reserve2;
    }
}

