/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.object.TlvObject;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class InfObjDeleteFuncEntity
extends InfObjEntity {
    private int sysType = 0;
    private int sysAddress = 0;
    private int compType = 0;
    private int compCirc = 0;
    private int compNode = 0;
    private List<TlvObject> tlvs = new ArrayList<TlvObject>();
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjDeleteFuncEntity entity) {
        if (data.length < 15) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61\uff0c\u6700\u5c0f\u957f\u5ea6\u4e3a15");
        }
        int count = data[7] & 0xFF;
        if (data.length != 15 + count) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61\uff0c\u957f\u5ea6=15" + count);
        }
        int index = 0;
        entity.sysType = data[index++] & 0xFF;
        entity.sysAddress = data[index++] & 0xFF;
        entity.compType = data[index++] & 0xFF;
        entity.compCirc = IntegerUtil.decodeInteger2byte(data, index);
        entity.compNode = IntegerUtil.decodeInteger2byte(data, index += 2);
        int tlvsSize = entity.compNode = IntegerUtil.decodeInteger2byte(data, index += 2);
        entity.tlvs = TlvObject.decodeTlvList(data, index += 2, tlvsSize);
        entity.time = TimeUtil.decodeTime6byte(data, index += tlvsSize);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjDeleteFuncEntity entity) {
        int tlvsSize = entity.getTlvsSize();
        byte[] data = new byte[15 + tlvsSize];
        int index = 0;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.sysAddress;
        data[index++] = (byte)entity.compType;
        IntegerUtil.encodeInteger2byte(entity.compCirc, data, index);
        IntegerUtil.encodeInteger2byte(entity.compNode, data, index += 2);
        IntegerUtil.encodeInteger2byte(tlvsSize, data, index += 2);
        index += 2;
        for (TlvObject tlv : entity.tlvs) {
            int length = tlv.encode(data, index);
            index += length;
        }
        TimeUtil.encodeTime6byte(entity.time, data, index);
        index += 6;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        int index = 2;
        for (int i = 0; i < count; ++i) {
            if (offset + (index += 7) >= data.length) {
                throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
            }
            int length = IntegerUtil.decodeInteger2byte(data, offset + index);
            index += 2;
            index += length;
            index += 6;
            aduList.add(15 + length);
        }
        if (aduLength != index) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        return aduList;
    }

    public int getTlvsSize() {
        int length = 0;
        for (TlvObject tlv : this.tlvs) {
            length += tlv.getEncodeLength();
        }
        return length;
    }

    @Override
    public void decode(byte[] data) {
        InfObjDeleteFuncEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjDeleteFuncEntity.encodeEntity(this);
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getSysAddress() {
        return this.sysAddress;
    }

    public int getCompType() {
        return this.compType;
    }

    public int getCompCirc() {
        return this.compCirc;
    }

    public int getCompNode() {
        return this.compNode;
    }

    public List<TlvObject> getTlvs() {
        return this.tlvs;
    }

    public String getTime() {
        return this.time;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setSysAddress(int sysAddress) {
        this.sysAddress = sysAddress;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public void setCompCirc(int compCirc) {
        this.compCirc = compCirc;
    }

    public void setCompNode(int compNode) {
        this.compNode = compNode;
    }

    public void setTlvs(List<TlvObject> tlvs) {
        this.tlvs = tlvs;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

