/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.dahua.fire.core.entity.infobj.InfObjEntity;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.IntegerUtil;
import cn.foxtech.device.protocol.v1.dahua.fire.core.utils.TimeUtil;
import cn.foxtech.device.protocol.v1.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;

public class InfObjCompStatusExEntity
extends InfObjEntity {
    private int sysType = 0;
    private int sysAddress = 0;
    private int compType = 0;
    private int compCirc = 0;
    private int compNode = 0;
    private long compStatus = 0L;
    private String compDescription = "";
    private String time = "2000-01-01 00:00:00";

    public static void decodeEntity(byte[] data, InfObjCompStatusExEntity entity) {
        if (data.length != entity.size()) {
            throw new ProtocolException("\u4fe1\u606f\u5bf9\u8c61" + entity.getClass().getSimpleName() + "\uff0c\u5fc5\u987b\u957f\u5ea6\u4e3a" + entity.size());
        }
        int index = 0;
        entity.sysType = data[index++] & 0xFF;
        entity.sysAddress = data[index++] & 0xFF;
        entity.compType = data[index++] & 0xFF;
        entity.compCirc = IntegerUtil.decodeInteger2byte(data, index);
        entity.compNode = IntegerUtil.decodeInteger2byte(data, index += 2);
        entity.compStatus = IntegerUtil.decodeLong8byte(data, index += 2);
        entity.compDescription = ByteUtils.decodeAscii((byte[])data, (int)(index += 8), (int)31, (boolean)true);
        entity.time = TimeUtil.decodeTime6byte(data, index += 31);
        index += 6;
    }

    public static byte[] encodeEntity(InfObjCompStatusExEntity entity) {
        byte[] data = new byte[entity.size()];
        int index = 0;
        data[index++] = (byte)entity.sysType;
        data[index++] = (byte)entity.sysAddress;
        data[index++] = (byte)entity.compType;
        IntegerUtil.encodeInteger2byte(entity.compCirc, data, index);
        IntegerUtil.encodeInteger2byte(entity.compNode, data, index += 2);
        IntegerUtil.encodeLong8byte(entity.compStatus, data, index += 2);
        ByteUtils.encodeAscii((String)entity.compDescription, (byte[])data, (int)(index += 8), (int)31, (boolean)true);
        TimeUtil.encodeTime6byte(entity.time, data, index += 31);
        index += 6;
        return data;
    }

    @Override
    public List<Integer> getAduSizes(byte[] data, int offset, int aduLength) {
        int count = data[offset + 1];
        int length = count * this.size();
        if (aduLength != 2 + length) {
            throw new ProtocolException("\u9a8c\u8bc1ADU\u7684\u957f\u5ea6\u4e0e\u5177\u4f53\u7684\u683c\u5f0f\uff0c\u4e0d\u5339\u914d");
        }
        ArrayList<Integer> aduList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            aduList.add(this.size());
        }
        return aduList;
    }

    public int size() {
        return 52;
    }

    @Override
    public void decode(byte[] data) {
        InfObjCompStatusExEntity.decodeEntity(data, this);
    }

    @Override
    public byte[] encode() {
        return InfObjCompStatusExEntity.encodeEntity(this);
    }

    public int getSysType() {
        return this.sysType;
    }

    public int getSysAddress() {
        return this.sysAddress;
    }

    public int getCompType() {
        return this.compType;
    }

    public int getCompCirc() {
        return this.compCirc;
    }

    public int getCompNode() {
        return this.compNode;
    }

    public long getCompStatus() {
        return this.compStatus;
    }

    public String getCompDescription() {
        return this.compDescription;
    }

    public String getTime() {
        return this.time;
    }

    public void setSysType(int sysType) {
        this.sysType = sysType;
    }

    public void setSysAddress(int sysAddress) {
        this.sysAddress = sysAddress;
    }

    public void setCompType(int compType) {
        this.compType = compType;
    }

    public void setCompCirc(int compCirc) {
        this.compCirc = compCirc;
    }

    public void setCompNode(int compNode) {
        this.compNode = compNode;
    }

    public void setCompStatus(long compStatus) {
        this.compStatus = compStatus;
    }

    public void setCompDescription(String compDescription) {
        this.compDescription = compDescription;
    }

    public void setTime(String time) {
        this.time = time;
    }
}

